/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.graph;

import org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.Iterators;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.graph.Graph;
import org.rascalmpl.com.google.common.graph.Network;
import org.rascalmpl.com.google.errorprone.annotations.Immutable;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.javax.annotation.CheckForNull;

@Immutable(containerOf={"org.rascalmpl.N"})
@ElementTypesAreNonnullByDefault
@Beta
public abstract class EndpointPair<N extends Object>
extends Object
implements Iterable<N> {
    private final N nodeU;
    private final N nodeV;

    private EndpointPair(N nodeU, N nodeV) {
        this.nodeU = Preconditions.checkNotNull(nodeU);
        this.nodeV = Preconditions.checkNotNull(nodeV);
    }

    public static <N extends Object> EndpointPair<N> ordered(N source, N target) {
        return new Ordered(source, target, null);
    }

    public static <N extends Object> EndpointPair<N> unordered(N nodeU, N nodeV) {
        return new Unordered(nodeV, nodeU, null);
    }

    static <N extends Object> EndpointPair<N> of(Graph<?> graph, N nodeU, N nodeV) {
        return graph.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
    }

    static <N extends Object> EndpointPair<N> of(Network<?, ?> network, N nodeU, N nodeV) {
        return network.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
    }

    public abstract N source();

    public abstract N target();

    public final N nodeU() {
        return this.nodeU;
    }

    public final N nodeV() {
        return this.nodeV;
    }

    public final N adjacentNode(N node) {
        if (node.equals(this.nodeU)) {
            return this.nodeV;
        }
        if (node.equals(this.nodeV)) {
            return this.nodeU;
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.EndpointPair ").append((Object)this).append((String)"org.rascalmpl. does not contain node ").append(node).toString());
    }

    public abstract boolean isOrdered();

    public final UnmodifiableIterator<N> iterator() {
        return Iterators.forArray((Object[])new Object[]{this.nodeU, this.nodeV});
    }

    public abstract boolean equals(@CheckForNull Object var1);

    public abstract int hashCode();

    /* synthetic */ EndpointPair(Object x0, Object x1, 1 x2) {
        this(x0, x1);
    }

    private static final class Unordered<N extends Object>
    extends EndpointPair<N> {
        private Unordered(N nodeU, N nodeV) {
            super((Object)nodeU, (Object)nodeV, null);
        }

        @Override
        public N source() {
            throw new UnsupportedOperationException((String)"org/rascalmpl/Cannot call source()/target() on a EndpointPair from an undirected graph. Consider calling adjacentNode(node) if you already have a node, or nodeU()/nodeV() if you don't.");
        }

        @Override
        public N target() {
            throw new UnsupportedOperationException((String)"org/rascalmpl/Cannot call source()/target() on a EndpointPair from an undirected graph. Consider calling adjacentNode(node) if you already have a node, or nodeU()/nodeV() if you don't.");
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean equals(@CheckForNull Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj;
            if (this.isOrdered() != other.isOrdered()) {
                return false;
            }
            if (this.nodeU().equals(other.nodeU())) {
                return this.nodeV().equals(other.nodeV());
            }
            return this.nodeU().equals(other.nodeV()) && this.nodeV().equals(other.nodeU());
        }

        @Override
        public int hashCode() {
            return this.nodeU().hashCode() + this.nodeV().hashCode();
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.[").append(this.nodeU()).append((String)"org.rascalmpl., ").append(this.nodeV()).append((String)"org.rascalmpl.]").toString();
        }

        /* synthetic */ Unordered(Object x0, Object x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static final class Ordered<N extends Object>
    extends EndpointPair<N> {
        private Ordered(N source, N target) {
            super((Object)source, (Object)target, null);
        }

        @Override
        public N source() {
            return this.nodeU();
        }

        @Override
        public N target() {
            return this.nodeV();
        }

        @Override
        public boolean isOrdered() {
            return true;
        }

        @Override
        public boolean equals(@CheckForNull Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj;
            if (this.isOrdered() != other.isOrdered()) {
                return false;
            }
            return this.source().equals(other.source()) && this.target().equals(other.target());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(new Object[]{this.source(), this.target()});
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.<").append(this.source()).append((String)"org.rascalmpl. -> ").append(this.target()).append((String)"org.rascalmpl.>").toString();
        }

        /* synthetic */ Ordered(Object x0, Object x1, 1 x2) {
            this(x0, x1);
        }
    }
}

