/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.graph;

import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.UnmodifiableIterator;
import org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.AbstractSet;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
class MapIteratorCache<K extends Object, V extends Object>
extends Object {
    private final Map<K, V> backingMap;
    @CheckForNull
    private volatile transient Map.Entry<K, V> cacheEntry;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V put(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        this.clearCache();
        return (V)this.backingMap.put(key, value);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V remove(Object key) {
        Preconditions.checkNotNull(key);
        this.clearCache();
        return (V)this.backingMap.remove(key);
    }

    final void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    @CheckForNull
    V get(Object key) {
        Preconditions.checkNotNull(key);
        V value = this.getIfCached(key);
        if (value == null) {
            return this.getWithoutCaching(key);
        }
        return value;
    }

    @CheckForNull
    final V getWithoutCaching(Object key) {
        Preconditions.checkNotNull(key);
        return (V)this.backingMap.get(key);
    }

    final boolean containsKey(@CheckForNull Object key) {
        return this.getIfCached(key) != null || this.backingMap.containsKey(key);
    }

    final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    public K next() {
                        Map.Entry entry = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.cacheEntry = entry;
                        return entry.getKey();
                    }
                };
            }

            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            public boolean contains(@CheckForNull Object key) {
                return MapIteratorCache.this.containsKey(key);
            }
        };
    }

    @CheckForNull
    V getIfCached(@CheckForNull Object key) {
        Map.Entry<K, V> entry = this.cacheEntry;
        if (entry != null && entry.getKey() == key) {
            return (V)entry.getValue();
        }
        return null;
    }

    void clearCache() {
        this.cacheEntry = null;
    }
}

