/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.graph;

import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.graph.DirectedMultiNetworkConnections;
import org.rascalmpl.com.google.common.graph.DirectedNetworkConnections;
import org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.graph.EndpointPair;
import org.rascalmpl.com.google.common.graph.MutableNetwork;
import org.rascalmpl.com.google.common.graph.NetworkBuilder;
import org.rascalmpl.com.google.common.graph.NetworkConnections;
import org.rascalmpl.com.google.common.graph.StandardNetwork;
import org.rascalmpl.com.google.common.graph.UndirectedMultiNetworkConnections;
import org.rascalmpl.com.google.common.graph.UndirectedNetworkConnections;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Objects;

@ElementTypesAreNonnullByDefault
final class StandardMutableNetwork<N extends Object, E extends Object>
extends StandardNetwork<N, E>
implements MutableNetwork<N, E> {
    StandardMutableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        super(builder);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, (Object)"org.rascalmpl.node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(node);
        return true;
    }

    @CanIgnoreReturnValue
    private NetworkConnections<N, E> addNodeInternal(N node) {
        NetworkConnections<N, E> connections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(node, connections) == null);
        return connections;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(N nodeU, N nodeV, E edge) {
        Preconditions.checkNotNull(nodeU, (Object)"org.rascalmpl.nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"org.rascalmpl.nodeV");
        Preconditions.checkNotNull(edge, (Object)"org.rascalmpl.edge");
        if (this.containsEdge(edge)) {
            EndpointPair existingIncidentNodes = this.incidentNodes(edge);
            EndpointPair<N> newIncidentNodes = EndpointPair.of(this, nodeU, nodeV);
            Preconditions.checkArgument(existingIncidentNodes.equals(newIncidentNodes), (String)"org.rascalmpl.Edge %s already exists between the following nodes: %s, so it cannot be reused to connect the following nodes: %s.", edge, existingIncidentNodes, newIncidentNodes);
            return false;
        }
        NetworkConnections<N, E> connectionsU = (NetworkConnections<N, E>)((java.lang.Object)this.nodeConnections.get((Object)nodeU));
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument(connectionsU == null || !connectionsU.successors().contains(nodeV), (String)"org.rascalmpl.Nodes %s and %s are already connected by a different edge. To construct a graph that allows parallel edges, call allowsParallelEdges(true) on the Builder.", nodeU, nodeV);
        }
        boolean isSelfLoop = nodeU.equals(nodeV);
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!isSelfLoop, (String)"org.rascalmpl.Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if (connectionsU == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        connectionsU.addOutEdge(edge, nodeV);
        NetworkConnections<N, E> connectionsV = (NetworkConnections<N, E>)((java.lang.Object)this.nodeConnections.get((Object)nodeV));
        if (connectionsV == null) {
            connectionsV = this.addNodeInternal(nodeV);
        }
        connectionsV.addInEdge(edge, nodeU, isSelfLoop);
        this.edgeToReferenceNode.put(edge, nodeU);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(EndpointPair<N> endpoints, E edge) {
        this.validateEndpoints(endpoints);
        return this.addEdge(endpoints.nodeU(), endpoints.nodeV(), edge);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(N node) {
        Preconditions.checkNotNull(node, (Object)"org.rascalmpl.node");
        NetworkConnections connections = (NetworkConnections)((java.lang.Object)this.nodeConnections.get((Object)node));
        if (connections == null) {
            return false;
        }
        Iterator iterator = ImmutableList.copyOf(connections.incidentEdges()).iterator();
        while (iterator.hasNext()) {
            Object edge = iterator.next();
            this.removeEdge(edge);
        }
        this.nodeConnections.remove((Object)node);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeEdge(E edge) {
        Preconditions.checkNotNull(edge, (Object)"org.rascalmpl.edge");
        java.lang.Object nodeU = this.edgeToReferenceNode.get((Object)edge);
        if (nodeU == null) {
            return false;
        }
        NetworkConnections connectionsU = (NetworkConnections)Objects.requireNonNull((Object)((NetworkConnections)((java.lang.Object)this.nodeConnections.get((Object)nodeU))));
        java.lang.Object nodeV = connectionsU.adjacentNode(edge);
        NetworkConnections connectionsV = (NetworkConnections)Objects.requireNonNull((Object)((NetworkConnections)((java.lang.Object)this.nodeConnections.get((Object)nodeV))));
        connectionsU.removeOutEdge(edge);
        connectionsV.removeInEdge(edge, this.allowsSelfLoops() && nodeU.equals(nodeV));
        this.edgeToReferenceNode.remove((Object)edge);
        return true;
    }

    private NetworkConnections<N, E> newConnections() {
        return this.isDirected() ? (this.allowsParallelEdges() ? DirectedMultiNetworkConnections.of() : DirectedNetworkConnections.of()) : (this.allowsParallelEdges() ? UndirectedMultiNetworkConnections.of() : UndirectedNetworkConnections.of());
    }
}

