/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.graph;

import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.graph.AbstractGraphBuilder;
import org.rascalmpl.com.google.common.graph.DirectedGraphConnections;
import org.rascalmpl.com.google.common.graph.ElementOrder;
import org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.graph.EndpointPair;
import org.rascalmpl.com.google.common.graph.GraphConnections;
import org.rascalmpl.com.google.common.graph.Graphs;
import org.rascalmpl.com.google.common.graph.MutableValueGraph;
import org.rascalmpl.com.google.common.graph.StandardValueGraph;
import org.rascalmpl.com.google.common.graph.UndirectedGraphConnections;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class StandardMutableValueGraph<N extends Object, V extends Object>
extends StandardValueGraph<N, V>
implements MutableValueGraph<N, V> {
    private final ElementOrder<N> incidentEdgeOrder;

    StandardMutableValueGraph(AbstractGraphBuilder<? super N> builder) {
        super(builder);
        this.incidentEdgeOrder = builder.incidentEdgeOrder.cast();
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return this.incidentEdgeOrder;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, (Object)"org.rascalmpl.node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(node);
        return true;
    }

    @CanIgnoreReturnValue
    private GraphConnections<N, V> addNodeInternal(N node) {
        GraphConnections<N, V> connections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(node, connections) == null);
        return connections;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V putEdgeValue(N nodeU, N nodeV, V value) {
        GraphConnections<N, V> connectionsU;
        Preconditions.checkNotNull(nodeU, (Object)"org.rascalmpl.nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"org.rascalmpl.nodeV");
        Preconditions.checkNotNull(value, (Object)"org.rascalmpl.value");
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!nodeU.equals(nodeV), (String)"org.rascalmpl.Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if ((connectionsU = (GraphConnections<N, V>)((java.lang.Object)this.nodeConnections.get((Object)nodeU))) == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        V previousValue = connectionsU.addSuccessor(nodeV, value);
        GraphConnections<N, V> connectionsV = (GraphConnections<N, V>)((java.lang.Object)this.nodeConnections.get((Object)nodeV));
        if (connectionsV == null) {
            connectionsV = this.addNodeInternal(nodeV);
        }
        connectionsV.addPredecessor(nodeU, value);
        if (previousValue == null) {
            Graphs.checkPositive(++this.edgeCount);
        }
        return previousValue;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V putEdgeValue(EndpointPair<N> endpoints, V value) {
        this.validateEndpoints(endpoints);
        return this.putEdgeValue(endpoints.nodeU(), endpoints.nodeV(), value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(N node) {
        Preconditions.checkNotNull(node, (Object)"org.rascalmpl.node");
        GraphConnections connections = (GraphConnections)((java.lang.Object)this.nodeConnections.get((Object)node));
        if (connections == null) {
            return false;
        }
        if (this.allowsSelfLoops() && connections.removeSuccessor(node) != null) {
            connections.removePredecessor(node);
            --this.edgeCount;
        }
        Iterator iterator = ImmutableList.copyOf(connections.successors()).iterator();
        while (iterator.hasNext()) {
            Object successor = iterator.next();
            ((GraphConnections)Objects.requireNonNull((Object)((GraphConnections)((java.lang.Object)this.nodeConnections.getWithoutCaching(successor))))).removePredecessor(node);
            Objects.requireNonNull(connections.removeSuccessor(successor));
            --this.edgeCount;
        }
        if (this.isDirected()) {
            iterator = ImmutableList.copyOf(connections.predecessors()).iterator();
            while (iterator.hasNext()) {
                Object predecessor = iterator.next();
                Preconditions.checkState(((GraphConnections)Objects.requireNonNull((Object)((GraphConnections)((java.lang.Object)this.nodeConnections.getWithoutCaching(predecessor))))).removeSuccessor(node) != null);
                connections.removePredecessor(predecessor);
                --this.edgeCount;
            }
        }
        this.nodeConnections.remove((Object)node);
        Graphs.checkNonNegative(this.edgeCount);
        return true;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V removeEdge(N nodeU, N nodeV) {
        Preconditions.checkNotNull(nodeU, (Object)"org.rascalmpl.nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"org.rascalmpl.nodeV");
        GraphConnections connectionsU = (GraphConnections)((java.lang.Object)this.nodeConnections.get((Object)nodeU));
        GraphConnections connectionsV = (GraphConnections)((java.lang.Object)this.nodeConnections.get((Object)nodeV));
        if (connectionsU == null || connectionsV == null) {
            return null;
        }
        java.lang.Object previousValue = connectionsU.removeSuccessor(nodeV);
        if (previousValue != null) {
            connectionsV.removePredecessor(nodeU);
            Graphs.checkNonNegative(--this.edgeCount);
        }
        return previousValue;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V removeEdge(EndpointPair<N> endpoints) {
        this.validateEndpoints(endpoints);
        return this.removeEdge(endpoints.nodeU(), endpoints.nodeV());
    }

    private GraphConnections<N, V> newConnections() {
        return this.isDirected() ? DirectedGraphConnections.of(this.incidentEdgeOrder) : UndirectedGraphConnections.of(this.incidentEdgeOrder);
    }
}

