/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.graph;

import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.graph.AbstractGraphBuilder;
import org.rascalmpl.com.google.common.graph.AbstractValueGraph;
import org.rascalmpl.com.google.common.graph.ElementOrder;
import org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.graph.EndpointPair;
import org.rascalmpl.com.google.common.graph.GraphConnections;
import org.rascalmpl.com.google.common.graph.Graphs;
import org.rascalmpl.com.google.common.graph.IncidentEdgeSet;
import org.rascalmpl.com.google.common.graph.MapIteratorCache;
import org.rascalmpl.com.google.common.graph.MapRetrievalCache;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.TreeMap;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
class StandardValueGraph<N extends Object, V extends Object>
extends AbstractValueGraph<N, V> {
    private final boolean isDirected;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    final MapIteratorCache<N, GraphConnections<N, V>> nodeConnections;
    long edgeCount;

    StandardValueGraph(AbstractGraphBuilder<? super N> builder) {
        this(builder, builder.nodeOrder.createMap(builder.expectedNodeCount.or(Integer.valueOf((int)10)).intValue()), 0L);
    }

    StandardValueGraph(AbstractGraphBuilder<? super N> builder, Map<N, GraphConnections<N, V>> nodeConnections, long edgeCount) {
        this.isDirected = builder.directed;
        this.allowsSelfLoops = builder.allowsSelfLoops;
        this.nodeOrder = builder.nodeOrder.cast();
        this.nodeConnections = nodeConnections instanceof TreeMap ? new MapRetrievalCache<N, GraphConnections<N, V>>(nodeConnections) : new MapIteratorCache<N, GraphConnections<N, V>>(nodeConnections);
        this.edgeCount = Graphs.checkNonNegative(edgeCount);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public Set<N> adjacentNodes(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).adjacentNodes(), node);
    }

    @Override
    public Set<N> predecessors(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).predecessors(), node);
    }

    @Override
    public Set<N> successors(N node) {
        return this.nodeInvalidatableSet(this.checkedConnections(node).successors(), node);
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N node) {
        final GraphConnections<N, V> connections = this.checkedConnections(node);
        IncidentEdgeSet incident = new IncidentEdgeSet<N>(this, (Object)node){

            public Iterator<EndpointPair<N>> iterator() {
                return connections.incidentEdgeIterator(this.node);
            }
        };
        return this.nodeInvalidatableSet(incident, node);
    }

    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        return this.hasEdgeConnectingInternal(Preconditions.checkNotNull(nodeU), Preconditions.checkNotNull(nodeV));
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        Preconditions.checkNotNull(endpoints);
        return this.isOrderingCompatible(endpoints) && this.hasEdgeConnectingInternal(endpoints.nodeU(), endpoints.nodeV());
    }

    @Override
    @CheckForNull
    public V edgeValueOrDefault(N nodeU, N nodeV, @CheckForNull V defaultValue) {
        return this.edgeValueOrDefaultInternal(Preconditions.checkNotNull(nodeU), Preconditions.checkNotNull(nodeV), defaultValue);
    }

    @Override
    @CheckForNull
    public V edgeValueOrDefault(EndpointPair<N> endpoints, @CheckForNull V defaultValue) {
        this.validateEndpoints(endpoints);
        return this.edgeValueOrDefaultInternal(endpoints.nodeU(), endpoints.nodeV(), defaultValue);
    }

    @Override
    protected long edgeCount() {
        return this.edgeCount;
    }

    private final GraphConnections<N, V> checkedConnections(N node) {
        GraphConnections<N, V> connections = this.nodeConnections.get((Object)node);
        if (connections == null) {
            Preconditions.checkNotNull(node);
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Node ").append(node).append((String)"org.rascalmpl. is not an element of this graph.").toString());
        }
        return connections;
    }

    final boolean containsNode(@CheckForNull N node) {
        return this.nodeConnections.containsKey((Object)node);
    }

    private final boolean hasEdgeConnectingInternal(N nodeU, N nodeV) {
        GraphConnections<N, V> connectionsU = this.nodeConnections.get((Object)nodeU);
        return connectionsU != null && connectionsU.successors().contains(nodeV);
    }

    @CheckForNull
    private final V edgeValueOrDefaultInternal(N nodeU, N nodeV, @CheckForNull V defaultValue) {
        V value;
        GraphConnections<N, V> connectionsU = this.nodeConnections.get((Object)nodeU);
        V v = value = connectionsU == null ? null : (V)connectionsU.value(nodeV);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

