/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.graph;

import org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.AbstractIterator;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.graph.BaseGraph;
import org.rascalmpl.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.graph.Network;
import org.rascalmpl.com.google.common.graph.SuccessorsFunction;
import org.rascalmpl.com.google.errorprone.annotations.DoNotMock;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.Deque;
import org.rascalmpl.java.util.HashSet;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.javax.annotation.CheckForNull;

@DoNotMock(value="org.rascalmpl.Call forGraph or forTree, passing a lambda or a Graph with the desired edges (built with GraphBuilder)")
@ElementTypesAreNonnullByDefault
@Beta
public abstract class Traverser<N extends org.rascalmpl.java.lang.Object>
extends org.rascalmpl.java.lang.Object {
    private final SuccessorsFunction<N> successorFunction;

    private Traverser(SuccessorsFunction<N> successorFunction) {
        this.successorFunction = Preconditions.checkNotNull(successorFunction);
    }

    public static <N extends org.rascalmpl.java.lang.Object> Traverser<N> forGraph(final SuccessorsFunction<N> graph) {
        return new Traverser<N>(graph){

            @Override
            Traversal<N> newTraversal() {
                return Traversal.inGraph(graph);
            }
        };
    }

    public static <N extends org.rascalmpl.java.lang.Object> Traverser<N> forTree(final SuccessorsFunction<N> tree) {
        if (tree instanceof BaseGraph) {
            Preconditions.checkArgument(((BaseGraph)tree).isDirected(), (org.rascalmpl.java.lang.Object)"org.rascalmpl.Undirected graphs can never be trees.");
        }
        if (tree instanceof Network) {
            Preconditions.checkArgument(((Network)tree).isDirected(), (org.rascalmpl.java.lang.Object)"org.rascalmpl.Undirected networks can never be trees.");
        }
        return new Traverser<N>(tree){

            @Override
            Traversal<N> newTraversal() {
                return Traversal.inTree(tree);
            }
        };
    }

    public final Iterable<N> breadthFirst(N startNode) {
        return this.breadthFirst((Iterable<? extends N>)ImmutableSet.of(startNode));
    }

    public final Iterable<N> breadthFirst(Iterable<? extends N> startNodes) {
        final ImmutableSet<? extends N> validated = this.validate(startNodes);
        return new Iterable<N>(){

            public Iterator<N> iterator() {
                return Traverser.this.newTraversal().breadthFirst(validated.iterator());
            }
        };
    }

    public final Iterable<N> depthFirstPreOrder(N startNode) {
        return this.depthFirstPreOrder((Iterable<? extends N>)ImmutableSet.of(startNode));
    }

    public final Iterable<N> depthFirstPreOrder(Iterable<? extends N> startNodes) {
        final ImmutableSet<? extends N> validated = this.validate(startNodes);
        return new Iterable<N>(){

            public Iterator<N> iterator() {
                return Traverser.this.newTraversal().preOrder(validated.iterator());
            }
        };
    }

    public final Iterable<N> depthFirstPostOrder(N startNode) {
        return this.depthFirstPostOrder((Iterable<? extends N>)ImmutableSet.of(startNode));
    }

    public final Iterable<N> depthFirstPostOrder(Iterable<? extends N> startNodes) {
        final ImmutableSet<? extends N> validated = this.validate(startNodes);
        return new Iterable<N>(){

            public Iterator<N> iterator() {
                return Traverser.this.newTraversal().postOrder(validated.iterator());
            }
        };
    }

    abstract Traversal<N> newTraversal();

    private ImmutableSet<N> validate(Iterable<? extends N> startNodes) {
        ImmutableSet<N> copy = ImmutableSet.copyOf(startNodes);
        Iterator iterator = copy.iterator();
        while (iterator.hasNext()) {
            org.rascalmpl.java.lang.Object node = iterator.next();
            this.successorFunction.successors(node);
        }
        return copy;
    }

    private static abstract class InsertionOrder
    extends Enum<InsertionOrder> {
        public static final /* enum */ InsertionOrder FRONT = new InsertionOrder(){

            @Override
            <T extends org.rascalmpl.java.lang.Object> void insertInto(Deque<T> deque, T value) {
                deque.addFirst(value);
            }
        };
        public static final /* enum */ InsertionOrder BACK = new InsertionOrder(){

            @Override
            <T extends org.rascalmpl.java.lang.Object> void insertInto(Deque<T> deque, T value) {
                deque.addLast(value);
            }
        };
        private static final /* synthetic */ InsertionOrder[] $VALUES;

        public static InsertionOrder[] values() {
            return (InsertionOrder[])$VALUES.clone();
        }

        public static InsertionOrder valueOf(String name) {
            return (InsertionOrder)Enum.valueOf(InsertionOrder.class, (String)name);
        }

        private InsertionOrder() {
            super((String)string, n);
        }

        abstract <T extends org.rascalmpl.java.lang.Object> void insertInto(Deque<T> var1, T var2);

        static {
            $VALUES = new InsertionOrder[]{FRONT, BACK};
        }
    }

    private static abstract class Traversal<N extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        final SuccessorsFunction<N> successorFunction;

        Traversal(SuccessorsFunction<N> successorFunction) {
            this.successorFunction = successorFunction;
        }

        static <N extends org.rascalmpl.java.lang.Object> Traversal<N> inGraph(SuccessorsFunction<N> graph) {
            HashSet visited = new HashSet();
            return new Traversal<N>(graph, (Set)visited){
                final /* synthetic */ Set val$visited;
                {
                    this.val$visited = set;
                    super(successorFunction);
                }

                @Override
                @CheckForNull
                N visitNext(Deque<Iterator<? extends N>> horizon) {
                    Iterator top = (Iterator)horizon.getFirst();
                    while (top.hasNext()) {
                        org.rascalmpl.java.lang.Object element = top.next();
                        Objects.requireNonNull((org.rascalmpl.java.lang.Object)element);
                        if (!this.val$visited.add(element)) continue;
                        return element;
                    }
                    horizon.removeFirst();
                    return null;
                }
            };
        }

        static <N extends org.rascalmpl.java.lang.Object> Traversal<N> inTree(SuccessorsFunction<N> tree) {
            return new Traversal<N>((SuccessorsFunction)tree){

                @Override
                @CheckForNull
                N visitNext(Deque<Iterator<? extends N>> horizon) {
                    Iterator top = (Iterator)horizon.getFirst();
                    if (top.hasNext()) {
                        return Preconditions.checkNotNull(top.next());
                    }
                    horizon.removeFirst();
                    return null;
                }
            };
        }

        final Iterator<N> breadthFirst(Iterator<? extends N> startNodes) {
            return this.topDown(startNodes, InsertionOrder.BACK);
        }

        final Iterator<N> preOrder(Iterator<? extends N> startNodes) {
            return this.topDown(startNodes, InsertionOrder.FRONT);
        }

        private Iterator<N> topDown(Iterator<? extends N> startNodes, InsertionOrder order) {
            ArrayDeque horizon = new ArrayDeque();
            horizon.add(startNodes);
            return new AbstractIterator<N>((Deque)horizon, order){
                final /* synthetic */ Deque val$horizon;
                final /* synthetic */ InsertionOrder val$order;
                {
                    this.val$horizon = deque;
                    this.val$order = insertionOrder;
                }

                @Override
                @CheckForNull
                protected N computeNext() {
                    do {
                        Object next;
                        if ((next = this.visitNext(this.val$horizon)) == null) continue;
                        Iterator successors = successorFunction.successors(next).iterator();
                        if (successors.hasNext()) {
                            this.val$order.insertInto(this.val$horizon, successors);
                        }
                        return next;
                    } while (!this.val$horizon.isEmpty());
                    return this.endOfData();
                }
            };
        }

        final Iterator<N> postOrder(Iterator<? extends N> startNodes) {
            ArrayDeque ancestorStack = new ArrayDeque();
            ArrayDeque horizon = new ArrayDeque();
            horizon.add(startNodes);
            return new AbstractIterator<N>((Deque)horizon, (Deque)ancestorStack){
                final /* synthetic */ Deque val$horizon;
                final /* synthetic */ Deque val$ancestorStack;
                {
                    this.val$horizon = deque;
                    this.val$ancestorStack = deque2;
                }

                @Override
                @CheckForNull
                protected N computeNext() {
                    Object next = this.visitNext(this.val$horizon);
                    while (next != null) {
                        Iterator successors = successorFunction.successors(next).iterator();
                        if (!successors.hasNext()) {
                            return next;
                        }
                        this.val$horizon.addFirst((org.rascalmpl.java.lang.Object)successors);
                        this.val$ancestorStack.push(next);
                        next = this.visitNext(this.val$horizon);
                    }
                    if (!this.val$ancestorStack.isEmpty()) {
                        return this.val$ancestorStack.pop();
                    }
                    return this.endOfData();
                }
            };
        }

        @CheckForNull
        abstract N visitNext(Deque<Iterator<? extends N>> var1);
    }
}

