/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.hash;

import org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.Objects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.com.google.common.hash.BloomFilterStrategies;
import org.rascalmpl.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.hash.Funnel;
import org.rascalmpl.com.google.common.hash.ParametricNullness;
import org.rascalmpl.com.google.common.math.DoubleMath;
import org.rascalmpl.com.google.common.math.LongMath;
import org.rascalmpl.com.google.common.primitives.SignedBytes;
import org.rascalmpl.com.google.common.primitives.UnsignedBytes;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.DataInputStream;
import org.rascalmpl.java.io.DataOutputStream;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InputStream;
import org.rascalmpl.java.io.InvalidObjectException;
import org.rascalmpl.java.io.ObjectInputStream;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.math.RoundingMode;
import org.rascalmpl.java.util.stream.Collector;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@Beta
public final class BloomFilter<T extends @Nullable org.rascalmpl.java.lang.Object>
extends org.rascalmpl.java.lang.Object
implements Predicate<T>,
Serializable {
    private final BloomFilterStrategies.LockFreeBitArray bits;
    private final int numHashFunctions;
    private final Funnel<? super T> funnel;
    private final Strategy strategy;
    private static final long serialVersionUID = -889275714L;

    private BloomFilter(BloomFilterStrategies.LockFreeBitArray bits, int numHashFunctions, Funnel<? super T> funnel, Strategy strategy) {
        Preconditions.checkArgument(numHashFunctions > 0, (String)"org.rascalmpl.numHashFunctions (%s) must be > 0", numHashFunctions);
        Preconditions.checkArgument(numHashFunctions <= 255, (String)"org.rascalmpl.numHashFunctions (%s) must be <= 255", numHashFunctions);
        this.bits = Preconditions.checkNotNull(bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = Preconditions.checkNotNull(funnel);
        this.strategy = Preconditions.checkNotNull(strategy);
    }

    public BloomFilter<T> copy() {
        return new BloomFilter<T>(this.bits.copy(), this.numHashFunctions, this.funnel, this.strategy);
    }

    public boolean mightContain(@ParametricNullness T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.bits);
    }

    @Override
    @Deprecated
    public boolean apply(@ParametricNullness T input) {
        return this.mightContain(input);
    }

    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness T object) {
        return this.strategy.put(object, this.funnel, this.numHashFunctions, this.bits);
    }

    public double expectedFpp() {
        return Math.pow((double)((double)this.bits.bitCount() / (double)this.bitSize()), (double)this.numHashFunctions);
    }

    public long approximateElementCount() {
        long bitSize = this.bits.bitSize();
        long bitCount = this.bits.bitCount();
        double fractionOfBitsSet = (double)bitCount / (double)bitSize;
        return DoubleMath.roundToLong(-Math.log1p((double)(-fractionOfBitsSet)) * (double)bitSize / (double)this.numHashFunctions, RoundingMode.HALF_UP);
    }

    @VisibleForTesting
    long bitSize() {
        return this.bits.bitSize();
    }

    public boolean isCompatible(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        return this != that && this.numHashFunctions == that.numHashFunctions && this.bitSize() == that.bitSize() && this.strategy.equals(that.strategy) && this.funnel.equals(that.funnel);
    }

    public void putAll(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        Preconditions.checkArgument(this != that, (org.rascalmpl.java.lang.Object)"org.rascalmpl.Cannot combine a BloomFilter with itself.");
        Preconditions.checkArgument(this.numHashFunctions == that.numHashFunctions, (String)"org.rascalmpl.BloomFilters must have the same number of hash functions (%s != %s)", this.numHashFunctions, that.numHashFunctions);
        Preconditions.checkArgument(this.bitSize() == that.bitSize(), (String)"org.rascalmpl.BloomFilters must have the same size underlying bit arrays (%s != %s)", this.bitSize(), that.bitSize());
        Preconditions.checkArgument(this.strategy.equals(that.strategy), (String)"org.rascalmpl.BloomFilters must have equal strategies (%s != %s)", (org.rascalmpl.java.lang.Object)this.strategy, (org.rascalmpl.java.lang.Object)that.strategy);
        Preconditions.checkArgument(this.funnel.equals(that.funnel), (String)"org.rascalmpl.BloomFilters must have equal funnels (%s != %s)", this.funnel, that.funnel);
        this.bits.putAll(that.bits);
    }

    @Override
    public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BloomFilter) {
            BloomFilter that = (BloomFilter)object;
            return this.numHashFunctions == that.numHashFunctions && this.funnel.equals(that.funnel) && this.bits.equals(that.bits) && this.strategy.equals(that.strategy);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.numHashFunctions), this.funnel, this.strategy, this.bits});
    }

    public static <T extends org.rascalmpl.java.lang.Object> Collector<T, ?, BloomFilter<T>> toBloomFilter(Funnel<? super T> funnel, long expectedInsertions) {
        return BloomFilter.toBloomFilter(funnel, expectedInsertions, 0.03);
    }

    /*
     * Exception decompiling
     */
    public static <T extends org.rascalmpl.java.lang.Object> Collector<T, ?, BloomFilter<T>> toBloomFilter(Funnel<? super T> funnel, long expectedInsertions, double fpp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends org.rascalmpl.java.lang.Object> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, (long)expectedInsertions, fpp);
    }

    public static <T extends org.rascalmpl.java.lang.Object> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, expectedInsertions, fpp, BloomFilterStrategies.MURMUR128_MITZ_64);
    }

    @VisibleForTesting
    static <T extends org.rascalmpl.java.lang.Object> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp, Strategy strategy) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(expectedInsertions >= 0L, (String)"org.rascalmpl.Expected insertions (%s) must be >= 0", expectedInsertions);
        Preconditions.checkArgument(fpp > 0.0, (String)"org.rascalmpl.False positive probability (%s) must be > 0.0", (org.rascalmpl.java.lang.Object)org.rascalmpl.java.lang.Double.valueOf((double)fpp));
        Preconditions.checkArgument(fpp < 1.0, (String)"org.rascalmpl.False positive probability (%s) must be < 1.0", (org.rascalmpl.java.lang.Object)org.rascalmpl.java.lang.Double.valueOf((double)fpp));
        Preconditions.checkNotNull(strategy);
        if (expectedInsertions == 0L) {
            expectedInsertions = 1L;
        }
        long numBits = BloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        int numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        try {
            return new BloomFilter<T>(new BloomFilterStrategies.LockFreeBitArray(numBits), numHashFunctions, funnel, strategy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Could not create BloomFilter of ").append(numBits).append((String)"org.rascalmpl. bits").toString(), (Throwable)((Object)e));
        }
    }

    public static <T extends org.rascalmpl.java.lang.Object> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions) {
        return BloomFilter.create(funnel, (long)expectedInsertions);
    }

    public static <T extends org.rascalmpl.java.lang.Object> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions) {
        return BloomFilter.create(funnel, expectedInsertions, 0.03);
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(long n, long m4) {
        return Math.max((int)1, (int)((int)Math.round((double)((double)m4 / (double)n * Math.log((double)2.0)))));
    }

    @VisibleForTesting
    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log((double)p) / (Math.log((double)2.0) * Math.log((double)2.0)));
    }

    private org.rascalmpl.java.lang.Object writeReplace() {
        return new SerialForm(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException((String)"org.rascalmpl.Use SerializedForm");
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeByte((int)SignedBytes.checkedCast(this.strategy.ordinal()));
        dout.writeByte((int)UnsignedBytes.checkedCast(this.numHashFunctions));
        dout.writeInt(this.bits.data.length());
        for (int i = 0; i < this.bits.data.length(); ++i) {
            dout.writeLong(this.bits.data.get(i));
        }
    }

    public static <T extends org.rascalmpl.java.lang.Object> BloomFilter<T> readFrom(InputStream in, Funnel<? super T> funnel) throws IOException {
        Preconditions.checkNotNull(in, (org.rascalmpl.java.lang.Object)"org.rascalmpl.InputStream");
        Preconditions.checkNotNull(funnel, (org.rascalmpl.java.lang.Object)"org.rascalmpl.Funnel");
        int strategyOrdinal = -1;
        int numHashFunctions = -1;
        int dataLength = -1;
        try {
            DataInputStream din = new DataInputStream(in);
            strategyOrdinal = din.readByte();
            numHashFunctions = UnsignedBytes.toInt(din.readByte());
            dataLength = din.readInt();
            BloomFilterStrategies strategy = BloomFilterStrategies.values()[strategyOrdinal];
            BloomFilterStrategies.LockFreeBitArray dataArray = new BloomFilterStrategies.LockFreeBitArray(LongMath.checkedMultiply(dataLength, 64L));
            for (int i = 0; i < dataLength; ++i) {
                dataArray.putData(i, din.readLong());
            }
            return new BloomFilter<T>(dataArray, numHashFunctions, funnel, strategy);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            String message = new StringBuilder().append((String)"org.rascalmpl.Unable to deserialize BloomFilter from InputStream. strategyOrdinal: ").append(strategyOrdinal).append((String)"org.rascalmpl. numHashFunctions: ").append(numHashFunctions).append((String)"org.rascalmpl. dataLength: ").append(dataLength).toString();
            throw new IOException(message, (Throwable)((Object)e));
        }
    }

    private static /* synthetic */ BloomFilter lambda$toBloomFilter$1(BloomFilter bf1, BloomFilter bf2) {
        bf1.putAll(bf2);
        return bf1;
    }

    private static /* synthetic */ BloomFilter lambda$toBloomFilter$0(Funnel funnel, long expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, expectedInsertions, fpp);
    }

    private static class SerialForm<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Serializable {
        final long[] data;
        final int numHashFunctions;
        final Funnel<? super T> funnel;
        final Strategy strategy;
        private static final long serialVersionUID = 1L;

        SerialForm(BloomFilter<T> bf) {
            this.data = BloomFilterStrategies.LockFreeBitArray.toPlainArray(((BloomFilter)bf).bits.data);
            this.numHashFunctions = ((BloomFilter)bf).numHashFunctions;
            this.funnel = ((BloomFilter)bf).funnel;
            this.strategy = ((BloomFilter)bf).strategy;
        }

        org.rascalmpl.java.lang.Object readResolve() {
            return new BloomFilter(new BloomFilterStrategies.LockFreeBitArray(this.data), this.numHashFunctions, this.funnel, this.strategy);
        }
    }

    static interface Strategy
    extends Serializable {
        public <T extends org.rascalmpl.java.lang.Object> boolean put(@ParametricNullness T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);

        public <T extends org.rascalmpl.java.lang.Object> boolean mightContain(@ParametricNullness T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.LockFreeBitArray var4);

        public int ordinal();
    }
}

