/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.hash;

import org.rascalmpl.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.primitives.Longs;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.NoSuchFieldError;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.Field;
import org.rascalmpl.java.nio.ByteOrder;
import org.rascalmpl.sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
final class LittleEndianByteArray
extends Object {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] input, int offset) {
        if (!$assertionsDisabled && input.length < offset + 8) {
            throw new AssertionError();
        }
        return byteArray.getLongLittleEndian(input, offset);
    }

    static long load64Safely(byte[] input, int offset, int length) {
        long result = 0L;
        int limit = Math.min((int)length, (int)8);
        for (int i = 0; i < limit; ++i) {
            result |= ((long)input[offset + i] & 0xFFL) << i * 8;
        }
        return result;
    }

    static void store64(byte[] sink, int offset, long value) {
        if (!($assertionsDisabled || offset >= 0 && offset + 8 <= sink.length)) {
            throw new AssertionError();
        }
        byteArray.putLongLittleEndian(sink, offset, value);
    }

    static int load32(byte[] source, int offset) {
        return source[offset] & 0xFF | (source[offset + 1] & 0xFF) << 8 | (source[offset + 2] & 0xFF) << 16 | (source[offset + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    static {
        Enum theGetter = JavaLittleEndianBytes.INSTANCE;
        try {
            String arch = System.getProperty((String)"org.rascalmpl.os.arch");
            if ("org.rascalmpl.amd64".equals((Object)arch) || "org.rascalmpl.aarch64".equals((Object)arch)) {
                theGetter = ByteOrder.nativeOrder().equals((Object)ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteArray = theGetter;
    }

    private static abstract class JavaLittleEndianBytes
    extends Enum<JavaLittleEndianBytes>
    implements LittleEndianBytes {
        public static final /* enum */ JavaLittleEndianBytes INSTANCE = new JavaLittleEndianBytes(){

            @Override
            public long getLongLittleEndian(byte[] source, int offset) {
                return Longs.fromBytes(source[offset + 7], source[offset + 6], source[offset + 5], source[offset + 4], source[offset + 3], source[offset + 2], source[offset + 1], source[offset]);
            }

            @Override
            public void putLongLittleEndian(byte[] sink, int offset, long value) {
                long mask = 255L;
                for (int i = 0; i < 8; ++i) {
                    sink[offset + i] = (byte)((value & mask) >> i * 8);
                    mask <<= 8;
                }
            }
        };
        private static final /* synthetic */ JavaLittleEndianBytes[] $VALUES;

        public static JavaLittleEndianBytes[] values() {
            return (JavaLittleEndianBytes[])$VALUES.clone();
        }

        public static JavaLittleEndianBytes valueOf(String name) {
            return (JavaLittleEndianBytes)Enum.valueOf(JavaLittleEndianBytes.class, (String)name);
        }

        private JavaLittleEndianBytes() {
            super((String)string, n);
        }

        static {
            $VALUES = new JavaLittleEndianBytes[]{INSTANCE};
        }
    }

    private static abstract class UnsafeByteArray
    extends Enum<UnsafeByteArray>
    implements LittleEndianBytes {
        public static final /* enum */ UnsafeByteArray UNSAFE_LITTLE_ENDIAN = new UnsafeByteArray(){

            @Override
            public long getLongLittleEndian(byte[] array, int offset) {
                return theUnsafe.getLong((Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            @Override
            public void putLongLittleEndian(byte[] array, int offset, long value) {
                theUnsafe.putLong((Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET, value);
            }
        };
        public static final /* enum */ UnsafeByteArray UNSAFE_BIG_ENDIAN = new UnsafeByteArray(){

            @Override
            public long getLongLittleEndian(byte[] array, int offset) {
                long bigEndian = theUnsafe.getLong((Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes((long)bigEndian);
            }

            @Override
            public void putLongLittleEndian(byte[] array, int offset, long value) {
                long littleEndianValue = Long.reverseBytes((long)value);
                theUnsafe.putLong((Object)array, (long)offset + (long)BYTE_ARRAY_BASE_OFFSET, littleEndianValue);
            }
        };
        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;
        private static final /* synthetic */ UnsafeByteArray[] $VALUES;

        public static UnsafeByteArray[] values() {
            return (UnsafeByteArray[])$VALUES.clone();
        }

        public static UnsafeByteArray valueOf(String name) {
            return (UnsafeByteArray)Enum.valueOf(UnsafeByteArray.class, (String)name);
        }

        private UnsafeByteArray() {
            super((String)string, n);
        }

        /*
         * Exception decompiling
         */
        private static Unsafe getUnsafe() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ Unsafe lambda$getUnsafe$0() throws Exception {
            Class<Unsafe> k = Unsafe.class;
            for (Field f : k.getDeclaredFields()) {
                f.setAccessible(true);
                Object x = f.get(null);
                if (!k.isInstance(x)) continue;
                return (Unsafe)k.cast(x);
            }
            throw new NoSuchFieldError((String)"org.rascalmpl.the Unsafe");
        }

        static {
            $VALUES = new UnsafeByteArray[]{UNSAFE_LITTLE_ENDIAN, UNSAFE_BIG_ENDIAN};
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }
}

