/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.io.ByteArrayDataInput;
import org.rascalmpl.com.google.common.io.ByteArrayDataOutput;
import org.rascalmpl.com.google.common.io.ByteProcessor;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.io.Java8Compatibility;
import org.rascalmpl.com.google.common.io.ParametricNullness;
import org.rascalmpl.com.google.common.math.IntMath;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.ByteArrayInputStream;
import org.rascalmpl.java.io.ByteArrayOutputStream;
import org.rascalmpl.java.io.DataInput;
import org.rascalmpl.java.io.DataInputStream;
import org.rascalmpl.java.io.DataOutput;
import org.rascalmpl.java.io.DataOutputStream;
import org.rascalmpl.java.io.EOFException;
import org.rascalmpl.java.io.FilterInputStream;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InputStream;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.IndexOutOfBoundsException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.OutOfMemoryError;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.nio.Buffer;
import org.rascalmpl.java.nio.ByteBuffer;
import org.rascalmpl.java.nio.channels.FileChannel;
import org.rascalmpl.java.nio.channels.ReadableByteChannel;
import org.rascalmpl.java.nio.channels.WritableByteChannel;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Queue;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class ByteStreams
extends org.rascalmpl.java.lang.Object {
    private static final int BUFFER_SIZE = 8192;
    private static final int ZERO_COPY_CHUNK_SIZE = 524288;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        public void write(int b) {
        }

        public void write(byte[] b) {
            Preconditions.checkNotNull(b);
        }

        public void write(byte[] b, int off, int len) {
            Preconditions.checkNotNull(b);
            Preconditions.checkPositionIndexes(off, off + len, b.length);
        }

        public String toString() {
            return "org.rascalmpl.ByteStreams.nullOutputStream()";
        }
    };

    static byte[] createBuffer() {
        return new byte[8192];
    }

    private ByteStreams() {
    }

    @CanIgnoreReturnValue
    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        byte[] buf = ByteStreams.createBuffer();
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    @CanIgnoreReturnValue
    public static long copy(ReadableByteChannel from, WritableByteChannel to) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        if (from instanceof FileChannel) {
            long copied;
            long oldPosition;
            FileChannel sourceChannel = (FileChannel)from;
            long position = oldPosition = sourceChannel.position();
            do {
                copied = sourceChannel.transferTo(position, 524288L, to);
                sourceChannel.position(position += copied);
            } while (copied > 0L || position < sourceChannel.size());
            return position - oldPosition;
        }
        ByteBuffer buf = ByteBuffer.wrap((byte[])ByteStreams.createBuffer());
        long total = 0L;
        while (from.read(buf) != -1) {
            Java8Compatibility.flip((Buffer)buf);
            while (buf.hasRemaining()) {
                total += (long)to.write(buf);
            }
            Java8Compatibility.clear((Buffer)buf);
        }
        return total;
    }

    private static byte[] toByteArrayInternal(InputStream in, Queue<byte[]> bufs, int totalLen) throws IOException {
        int initialBufferSize;
        int bufSize = initialBufferSize = Math.min((int)8192, (int)Math.max((int)128, (int)(Integer.highestOneBit((int)totalLen) * 2)));
        while (totalLen < 0x7FFFFFF7) {
            byte[] buf = new byte[Math.min((int)bufSize, (int)(0x7FFFFFF7 - totalLen))];
            bufs.add((org.rascalmpl.java.lang.Object)buf);
            int off = 0;
            while (off < buf.length) {
                int r = in.read(buf, off, buf.length - off);
                if (r == -1) {
                    return ByteStreams.combineBuffers(bufs, totalLen);
                }
                off += r;
                totalLen += r;
            }
            bufSize = IntMath.saturatedMultiply(bufSize, bufSize < 4096 ? 4 : 2);
        }
        if (in.read() == -1) {
            return ByteStreams.combineBuffers(bufs, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError((String)"org.rascalmpl.input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Queue<byte[]> bufs, int totalLen) {
        if (bufs.isEmpty()) {
            return new byte[0];
        }
        byte[] result = (byte[])bufs.remove();
        if (result.length == totalLen) {
            return result;
        }
        int remaining = totalLen - result.length;
        result = Arrays.copyOf((byte[])result, (int)totalLen);
        while (remaining > 0) {
            byte[] buf = (byte[])bufs.remove();
            int bytesToCopy = Math.min((int)remaining, (int)buf.length);
            int resultOffset = totalLen - remaining;
            System.arraycopy((org.rascalmpl.java.lang.Object)buf, (int)0, (org.rascalmpl.java.lang.Object)result, (int)resultOffset, (int)bytesToCopy);
            remaining -= bytesToCopy;
        }
        return result;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        Preconditions.checkNotNull(in);
        return ByteStreams.toByteArrayInternal(in, (Queue<byte[]>)new ArrayDeque(20), 0);
    }

    static byte[] toByteArray(InputStream in, long expectedSize) throws IOException {
        int read;
        Preconditions.checkArgument(expectedSize >= 0L, (String)"org.rascalmpl.expectedSize (%s) must be non-negative", expectedSize);
        if (expectedSize > 0x7FFFFFF7L) {
            throw new OutOfMemoryError(new StringBuilder().append(expectedSize).append((String)"org.rascalmpl. bytes is too large to fit in a byte array").toString());
        }
        byte[] bytes = new byte[(int)expectedSize];
        for (int remaining = (int)expectedSize; remaining > 0; remaining -= read) {
            int off = (int)expectedSize - remaining;
            read = in.read(bytes, off, remaining);
            if (read != -1) continue;
            return Arrays.copyOf((byte[])bytes, (int)off);
        }
        int b = in.read();
        if (b == -1) {
            return bytes;
        }
        ArrayDeque bufs = new ArrayDeque(22);
        bufs.add((org.rascalmpl.java.lang.Object)bytes);
        bufs.add((org.rascalmpl.java.lang.Object)new byte[]{(byte)b});
        return ByteStreams.toByteArrayInternal(in, (Queue<byte[]>)bufs, bytes.length + 1);
    }

    @CanIgnoreReturnValue
    public static long exhaust(InputStream in) throws IOException {
        long read;
        long total = 0L;
        byte[] buf = ByteStreams.createBuffer();
        while ((read = (long)in.read(buf)) != -1L) {
            total += read;
        }
        return total;
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes) {
        return ByteStreams.newDataInput(new ByteArrayInputStream(bytes));
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes, int start) {
        Preconditions.checkPositionIndex(start, bytes.length);
        return ByteStreams.newDataInput(new ByteArrayInputStream(bytes, start, bytes.length - start));
    }

    public static ByteArrayDataInput newDataInput(ByteArrayInputStream byteArrayInputStream) {
        return new ByteArrayDataInputStream(Preconditions.checkNotNull(byteArrayInputStream));
    }

    public static ByteArrayDataOutput newDataOutput() {
        return ByteStreams.newDataOutput(new ByteArrayOutputStream());
    }

    public static ByteArrayDataOutput newDataOutput(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.Invalid size: %s", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)size)}));
        }
        return ByteStreams.newDataOutput(new ByteArrayOutputStream(size));
    }

    public static ByteArrayDataOutput newDataOutput(ByteArrayOutputStream byteArrayOutputStream) {
        return new ByteArrayDataOutputStream(Preconditions.checkNotNull(byteArrayOutputStream));
    }

    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    public static InputStream limit(InputStream in, long limit) {
        return new LimitedInputStream(in, limit);
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        ByteStreams.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int read = ByteStreams.read(in, b, off, len);
        if (read != len) {
            throw new EOFException(new StringBuilder().append((String)"org.rascalmpl.reached end of stream after reading ").append(read).append((String)"org.rascalmpl. bytes; ").append(len).append((String)"org.rascalmpl. bytes expected").toString());
        }
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        long skipped = ByteStreams.skipUpTo(in, n);
        if (skipped < n) {
            throw new EOFException(new StringBuilder().append((String)"org.rascalmpl.reached end of stream after skipping ").append(skipped).append((String)"org.rascalmpl. bytes; ").append(n).append((String)"org.rascalmpl. bytes expected").toString());
        }
    }

    static long skipUpTo(InputStream in, long n) throws IOException {
        long totalSkipped;
        long skipped;
        byte[] buf = null;
        for (totalSkipped = 0L; totalSkipped < n; totalSkipped += skipped) {
            long remaining = n - totalSkipped;
            skipped = ByteStreams.skipSafely(in, remaining);
            if (skipped != 0L) continue;
            int skip = (int)Math.min((long)remaining, (long)8192L);
            if (buf == null) {
                buf = new byte[skip];
            }
            if ((skipped = (long)in.read(buf, 0, skip)) == -1L) break;
        }
        return totalSkipped;
    }

    private static long skipSafely(InputStream in, long n) throws IOException {
        int available = in.available();
        return available == 0 ? 0L : in.skip(Math.min((long)available, (long)n));
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <T extends org.rascalmpl.java.lang.Object> T readBytes(InputStream input, ByteProcessor<T> processor) throws IOException {
        int read;
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(processor);
        byte[] buf = ByteStreams.createBuffer();
        while ((read = input.read(buf)) != -1 && processor.processBytes(buf, 0, read)) {
        }
        return processor.getResult();
    }

    @CanIgnoreReturnValue
    public static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        Preconditions.checkNotNull(in);
        Preconditions.checkNotNull(b);
        if (len < 0) {
            throw new IndexOutOfBoundsException(String.format((String)"org.rascalmpl.len (%s) cannot be negative", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)len)}));
        }
        Preconditions.checkPositionIndexes(off, off + len, b.length);
        for (total = 0; total < len && (result = in.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    private static final class LimitedInputStream
    extends FilterInputStream {
        private long left;
        private long mark = -1L;

        LimitedInputStream(InputStream in, long limit) {
            super(in);
            Preconditions.checkNotNull(in);
            Preconditions.checkArgument(limit >= 0L, (org.rascalmpl.java.lang.Object)"org.rascalmpl.limit must be non-negative");
            this.left = limit;
        }

        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), (long)this.left);
        }

        public synchronized void mark(int readLimit) {
            this.in.mark(readLimit);
            this.mark = this.left;
        }

        public int read() throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int result = this.in.read();
            if (result != -1) {
                --this.left;
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int result = this.in.read(b, off, len = (int)Math.min((long)len, (long)this.left));
            if (result != -1) {
                this.left -= (long)result;
            }
            return result;
        }

        public synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException((String)"org.rascalmpl.Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException((String)"org.rascalmpl.Mark not set");
            }
            this.in.reset();
            this.left = this.mark;
        }

        public long skip(long n) throws IOException {
            n = Math.min((long)n, (long)this.left);
            long skipped = this.in.skip(n);
            this.left -= skipped;
            return skipped;
        }
    }

    private static class ByteArrayDataOutputStream
    extends org.rascalmpl.java.lang.Object
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputStream;

        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            this.byteArrayOutputStream = byteArrayOutputStream;
            this.output = new DataOutputStream((OutputStream)byteArrayOutputStream);
        }

        @Override
        public void write(int b) {
            try {
                this.output.write(b);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void write(byte[] b) {
            try {
                this.output.write(b);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                this.output.write(b, off, len);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeBoolean(boolean v) {
            try {
                this.output.writeBoolean(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeByte(int v) {
            try {
                this.output.writeByte(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeBytes(String s2) {
            try {
                this.output.writeBytes(s2);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeChar(int v) {
            try {
                this.output.writeChar(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeChars(String s2) {
            try {
                this.output.writeChars(s2);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeDouble(double v) {
            try {
                this.output.writeDouble(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeFloat(float v) {
            try {
                this.output.writeFloat(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeInt(int v) {
            try {
                this.output.writeInt(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeLong(long v) {
            try {
                this.output.writeLong(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeShort(int v) {
            try {
                this.output.writeShort(v);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public void writeUTF(String s2) {
            try {
                this.output.writeUTF(s2);
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public byte[] toByteArray() {
            return this.byteArrayOutputStream.toByteArray();
        }
    }

    private static class ByteArrayDataInputStream
    extends org.rascalmpl.java.lang.Object
    implements ByteArrayDataInput {
        final DataInput input;

        ByteArrayDataInputStream(ByteArrayInputStream byteArrayInputStream) {
            this.input = new DataInputStream((InputStream)byteArrayInputStream);
        }

        @Override
        public void readFully(byte[] b) {
            try {
                this.input.readFully(b);
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            try {
                this.input.readFully(b, off, len);
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public int skipBytes(int n) {
            try {
                return this.input.skipBytes(n);
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
            catch (IOException impossible) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)impossible);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        @CheckForNull
        public String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }

        @Override
        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException e) {
                throw new IllegalStateException((Throwable)((Object)e));
            }
        }
    }
}

