/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.nio.CharBuffer;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class CharSequenceReader
extends Reader {
    @CheckForNull
    private CharSequence seq;
    private int pos;
    private int mark;

    public CharSequenceReader(CharSequence seq) {
        this.seq = Preconditions.checkNotNull(seq);
    }

    private void checkOpen() throws IOException {
        if (this.seq == null) {
            throw new IOException((String)"org.rascalmpl.reader closed");
        }
    }

    private boolean hasRemaining() {
        return this.remaining() > 0;
    }

    private int remaining() {
        Objects.requireNonNull((Object)this.seq);
        return this.seq.length() - this.pos;
    }

    public synchronized int read(CharBuffer target) throws IOException {
        Preconditions.checkNotNull(target);
        this.checkOpen();
        Objects.requireNonNull((Object)this.seq);
        if (!this.hasRemaining()) {
            return -1;
        }
        int charsToRead = Math.min((int)target.remaining(), (int)this.remaining());
        for (int i = 0; i < charsToRead; ++i) {
            target.put(this.seq.charAt(this.pos++));
        }
        return charsToRead;
    }

    public synchronized int read() throws IOException {
        this.checkOpen();
        Objects.requireNonNull((Object)this.seq);
        return this.hasRemaining() ? (int)this.seq.charAt(this.pos++) : -1;
    }

    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        Preconditions.checkPositionIndexes(off, off + len, cbuf.length);
        this.checkOpen();
        Objects.requireNonNull((Object)this.seq);
        if (!this.hasRemaining()) {
            return -1;
        }
        int charsToRead = Math.min((int)len, (int)this.remaining());
        for (int i = 0; i < charsToRead; ++i) {
            cbuf[off + i] = this.seq.charAt(this.pos++);
        }
        return charsToRead;
    }

    public synchronized long skip(long n) throws IOException {
        Preconditions.checkArgument(n >= 0L, (String)"org.rascalmpl.n (%s) may not be negative", n);
        this.checkOpen();
        int charsToSkip = (int)Math.min((long)this.remaining(), (long)n);
        this.pos += charsToSkip;
        return charsToSkip;
    }

    public synchronized boolean ready() throws IOException {
        this.checkOpen();
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readAheadLimit) throws IOException {
        Preconditions.checkArgument(readAheadLimit >= 0, (String)"org.rascalmpl.readAheadLimit (%s) may not be negative", readAheadLimit);
        this.checkOpen();
        this.mark = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.checkOpen();
        this.pos = this.mark;
    }

    public synchronized void close() throws IOException {
        this.seq = null;
    }
}

