/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Optional;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.graph.SuccessorsFunction;
import org.rascalmpl.com.google.common.graph.Traverser;
import org.rascalmpl.com.google.common.hash.HashCode;
import org.rascalmpl.com.google.common.hash.HashFunction;
import org.rascalmpl.com.google.common.io.ByteProcessor;
import org.rascalmpl.com.google.common.io.ByteSink;
import org.rascalmpl.com.google.common.io.ByteSource;
import org.rascalmpl.com.google.common.io.ByteStreams;
import org.rascalmpl.com.google.common.io.CharSink;
import org.rascalmpl.com.google.common.io.CharSource;
import org.rascalmpl.com.google.common.io.Closer;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.io.FileWriteMode;
import org.rascalmpl.com.google.common.io.LineProcessor;
import org.rascalmpl.com.google.common.io.ParametricNullness;
import org.rascalmpl.com.google.common.io.TempFileCreator;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.InlineMe;
import org.rascalmpl.java.io.BufferedReader;
import org.rascalmpl.java.io.BufferedWriter;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.FileInputStream;
import org.rascalmpl.java.io.FileNotFoundException;
import org.rascalmpl.java.io.FileOutputStream;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InputStream;
import org.rascalmpl.java.io.InputStreamReader;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.io.OutputStreamWriter;
import org.rascalmpl.java.io.RandomAccessFile;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.io.Writer;
import org.rascalmpl.java.lang.Appendable;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.nio.MappedByteBuffer;
import org.rascalmpl.java.nio.channels.FileChannel;
import org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class Files
extends org.rascalmpl.java.lang.Object {
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        @Override
        public Iterable<File> successors(File file) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                return Collections.unmodifiableList((List)Arrays.asList((org.rascalmpl.java.lang.Object[])files));
            }
            return ImmutableList.of();
        }
    };

    private Files() {
    }

    public static BufferedReader newReader(File file, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedWriter newWriter(File file, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static ByteSource asByteSource(File file) {
        return new FileByteSource(file);
    }

    public static ByteSink asByteSink(File file, FileWriteMode ... modes) {
        return new FileByteSink(file, modes);
    }

    public static CharSource asCharSource(File file, Charset charset) {
        return Files.asByteSource(file).asCharSource(charset);
    }

    public static CharSink asCharSink(File file, Charset charset, FileWriteMode ... modes) {
        return Files.asByteSink(file, modes).asCharSink(charset);
    }

    public static byte[] toByteArray(File file) throws IOException {
        return Files.asByteSource(file).read();
    }

    @Deprecated
    @InlineMe(replacement="org.rascalmpl.Files.asCharSource(file, charset).read()", imports={"org.rascalmpl.com.google.common.io.Files"})
    public static String toString(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).read();
    }

    public static void write(byte[] from, File to) throws IOException {
        Files.asByteSink(to, new FileWriteMode[0]).write(from);
    }

    @Deprecated
    @InlineMe(replacement="org.rascalmpl.Files.asCharSink(to, charset).write(from)", imports={"org.rascalmpl.com.google.common.io.Files"})
    public static void write(CharSequence from, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, new FileWriteMode[0]).write(from);
    }

    public static void copy(File from, OutputStream to) throws IOException {
        Files.asByteSource(from).copyTo(to);
    }

    public static void copy(File from, File to) throws IOException {
        Preconditions.checkArgument(!from.equals((org.rascalmpl.java.lang.Object)to), (String)"org.rascalmpl.Source %s and destination %s must be different", (org.rascalmpl.java.lang.Object)from, (org.rascalmpl.java.lang.Object)to);
        Files.asByteSource(from).copyTo(Files.asByteSink(to, new FileWriteMode[0]));
    }

    @Deprecated
    @InlineMe(replacement="org.rascalmpl.Files.asCharSource(from, charset).copyTo(to)", imports={"org.rascalmpl.com.google.common.io.Files"})
    public static void copy(File from, Charset charset, Appendable to) throws IOException {
        Files.asCharSource(from, charset).copyTo(to);
    }

    @Deprecated
    @InlineMe(replacement="org.rascalmpl.Files.asCharSink(to, charset, FileWriteMode.APPEND).write(from)", imports={"org.rascalmpl.com.google.common.io.FileWriteMode", "org.rascalmpl.com.google.common.io.Files"})
    public static void append(CharSequence from, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, FileWriteMode.APPEND).write(from);
    }

    public static boolean equal(File file1, File file2) throws IOException {
        Preconditions.checkNotNull(file1);
        Preconditions.checkNotNull(file2);
        if (file1 == file2 || file1.equals((org.rascalmpl.java.lang.Object)file2)) {
            return true;
        }
        long len1 = file1.length();
        long len2 = file2.length();
        if (len1 != 0L && len2 != 0L && len1 != len2) {
            return false;
        }
        return Files.asByteSource(file1).contentEquals(Files.asByteSource(file2));
    }

    @Deprecated
    @Beta
    public static File createTempDir() {
        return TempFileCreator.INSTANCE.createTempDir();
    }

    public static void touch(File file) throws IOException {
        Preconditions.checkNotNull(file);
        if (!file.createNewFile() && !file.setLastModified(System.currentTimeMillis())) {
            throw new IOException(new StringBuilder().append((String)"org.rascalmpl.Unable to update modification time of ").append((org.rascalmpl.java.lang.Object)file).toString());
        }
    }

    public static void createParentDirs(File file) throws IOException {
        Preconditions.checkNotNull(file);
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!parent.isDirectory()) {
            throw new IOException(new StringBuilder().append((String)"org.rascalmpl.Unable to create parent directories of ").append((org.rascalmpl.java.lang.Object)file).toString());
        }
    }

    public static void move(File from, File to) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        Preconditions.checkArgument(!from.equals((org.rascalmpl.java.lang.Object)to), (String)"org.rascalmpl.Source %s and destination %s must be different", (org.rascalmpl.java.lang.Object)from, (org.rascalmpl.java.lang.Object)to);
        if (!from.renameTo(to)) {
            Files.copy(from, to);
            if (!from.delete()) {
                if (!to.delete()) {
                    throw new IOException(new StringBuilder().append((String)"org.rascalmpl.Unable to delete ").append((org.rascalmpl.java.lang.Object)to).toString());
                }
                throw new IOException(new StringBuilder().append((String)"org.rascalmpl.Unable to delete ").append((org.rascalmpl.java.lang.Object)from).toString());
            }
        }
    }

    @Deprecated
    @CheckForNull
    @InlineMe(replacement="org.rascalmpl.Files.asCharSource(file, charset).readFirstLine()", imports={"org.rascalmpl.com.google.common.io.Files"})
    public static String readFirstLine(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).readFirstLine();
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add((org.rascalmpl.java.lang.Object)line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    @Deprecated
    @ParametricNullness
    @InlineMe(replacement="org.rascalmpl.Files.asCharSource(file, charset).readLines(callback)", imports={"org.rascalmpl.com.google.common.io.Files"})
    @CanIgnoreReturnValue
    public static <T extends org.rascalmpl.java.lang.Object> T readLines(File file, Charset charset, LineProcessor<T> callback) throws IOException {
        return Files.asCharSource(file, charset).readLines(callback);
    }

    @Deprecated
    @ParametricNullness
    @InlineMe(replacement="org.rascalmpl.Files.asByteSource(file).read(processor)", imports={"org.rascalmpl.com.google.common.io.Files"})
    @CanIgnoreReturnValue
    public static <T extends org.rascalmpl.java.lang.Object> T readBytes(File file, ByteProcessor<T> processor) throws IOException {
        return Files.asByteSource(file).read(processor);
    }

    @Deprecated
    @InlineMe(replacement="org.rascalmpl.Files.asByteSource(file).hash(hashFunction)", imports={"org.rascalmpl.com.google.common.io.Files"})
    public static HashCode hash(File file, HashFunction hashFunction) throws IOException {
        return Files.asByteSource(file).hash(hashFunction);
    }

    public static MappedByteBuffer map(File file) throws IOException {
        Preconditions.checkNotNull(file);
        return Files.map(file, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mode) throws IOException {
        return Files.mapInternal(file, mode, -1L);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkArgument(size >= 0L, (String)"org.rascalmpl.size (%s) may not be negative", size);
        return Files.mapInternal(file, mode, size);
    }

    private static MappedByteBuffer mapInternal(File file, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(mode);
        try (Closer closer = Closer.create();){
            RandomAccessFile raf = closer.register(new RandomAccessFile(file, (String)(mode == FileChannel.MapMode.READ_ONLY ? "org.rascalmpl.r" : "org.rascalmpl.rw")));
            FileChannel channel = closer.register(raf.getChannel());
            MappedByteBuffer mappedByteBuffer = channel.map(mode, 0L, size == -1L ? channel.size() : size);
            return mappedByteBuffer;
        }
    }

    /*
     * Exception decompiling
     */
    public static String simplifyPath(String pathname) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$TooOptimisticMatchException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.getString(SwitchStringRewriter.java:404)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.access$600(SwitchStringRewriter.java:53)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$SwitchStringMatchResultCollector.collectMatches(SwitchStringRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleeneN.match(KleeneN.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchSequence.match(MatchSequence.java:26)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:23)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewriteComplex(SwitchStringRewriter.java:201)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewrite(SwitchStringRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:881)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getFileExtension(String fullName) {
        Preconditions.checkNotNull(fullName);
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "org.rascalmpl." : fileName.substring(dotIndex + 1);
    }

    public static String getNameWithoutExtension(String file) {
        Preconditions.checkNotNull(file);
        String fileName = new File(file).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static Traverser<File> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    public static Predicate<File> isDirectory() {
        return FilePredicate.IS_DIRECTORY;
    }

    public static Predicate<File> isFile() {
        return FilePredicate.IS_FILE;
    }

    private static abstract class FilePredicate
    extends Enum<FilePredicate>
    implements Predicate<File> {
        public static final /* enum */ FilePredicate IS_DIRECTORY = new FilePredicate(){

            @Override
            public boolean apply(File file) {
                return file.isDirectory();
            }

            public String toString() {
                return "org.rascalmpl.Files.isDirectory()";
            }
        };
        public static final /* enum */ FilePredicate IS_FILE = new FilePredicate(){

            @Override
            public boolean apply(File file) {
                return file.isFile();
            }

            public String toString() {
                return "org.rascalmpl.Files.isFile()";
            }
        };
        private static final /* synthetic */ FilePredicate[] $VALUES;

        public static FilePredicate[] values() {
            return (FilePredicate[])$VALUES.clone();
        }

        public static FilePredicate valueOf(String name) {
            return (FilePredicate)Enum.valueOf(FilePredicate.class, (String)name);
        }

        private FilePredicate() {
            super((String)string, n);
        }

        static {
            $VALUES = new FilePredicate[]{IS_DIRECTORY, IS_FILE};
        }
    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file, FileWriteMode ... modes) {
            this.file = Preconditions.checkNotNull(file);
            this.modes = ImmutableSet.copyOf((org.rascalmpl.java.lang.Object[])modes);
        }

        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((org.rascalmpl.java.lang.Object)FileWriteMode.APPEND));
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Files.asByteSink(").append((org.rascalmpl.java.lang.Object)this.file).append((String)"org.rascalmpl., ").append(this.modes).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file) {
            this.file = Preconditions.checkNotNull(file);
        }

        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(Long.valueOf((long)this.file.length()));
            }
            return Optional.absent();
        }

        @Override
        public long size() throws IOException {
            if (!this.file.isFile()) {
                throw new FileNotFoundException(this.file.toString());
            }
            return this.file.length();
        }

        @Override
        public byte[] read() throws IOException {
            try (Closer closer = Closer.create();){
                FileInputStream in = closer.register(this.openStream());
                byte[] byArray = ByteStreams.toByteArray((InputStream)in, in.getChannel().size());
                return byArray;
            }
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.Files.asByteSource(").append((org.rascalmpl.java.lang.Object)this.file).append((String)"org.rascalmpl.)").toString();
        }
    }
}

