/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.Beta;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.java.io.Flushable;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class Flushables
extends Object {
    private static final Logger logger = Logger.getLogger((String)Flushables.class.getName());

    private Flushables() {
    }

    public static void flush(Flushable flushable, boolean swallowIOException) throws IOException {
        try {
            flushable.flush();
        }
        catch (IOException e) {
            if (swallowIOException) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.IOException thrown while flushing Flushable.", (Throwable)((java.lang.Object)e));
            }
            throw e;
        }
    }

    @Beta
    public static void flushQuietly(Flushable flushable) {
        try {
            Flushables.flush(flushable, true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, (String)"org.rascalmpl.IOException should not have been thrown.", (Throwable)((java.lang.Object)e));
        }
    }
}

