/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.io.CharStreams;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.io.Java8Compatibility;
import org.rascalmpl.com.google.common.io.LineBuffer;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Readable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.nio.Buffer;
import org.rascalmpl.java.nio.CharBuffer;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.Queue;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class LineReader
extends Object {
    private final Readable readable;
    @CheckForNull
    private final Reader reader;
    private final CharBuffer cbuf = CharStreams.createBuffer();
    private final char[] buf = this.cbuf.array();
    private final Queue<String> lines = new ArrayDeque();
    private final LineBuffer lineBuf = new LineBuffer(){

        @Override
        protected void handleLine(String line, String end) {
            LineReader.this.lines.add((Object)line);
        }
    };

    public LineReader(Readable readable) {
        this.readable = Preconditions.checkNotNull(readable);
        this.reader = readable instanceof Reader ? (Reader)readable : null;
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public String readLine() throws IOException {
        while (this.lines.peek() == null) {
            int read;
            Java8Compatibility.clear((Buffer)this.cbuf);
            int n = read = this.reader != null ? this.reader.read(this.buf, 0, this.buf.length) : this.readable.read(this.cbuf);
            if (read == -1) {
                this.lineBuf.finish();
                break;
            }
            this.lineBuf.add(this.buf, 0, read);
        }
        return (String)this.lines.poll();
    }
}

