/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.primitives.Longs;
import org.rascalmpl.java.io.DataOutput;
import org.rascalmpl.java.io.DataOutputStream;
import org.rascalmpl.java.io.FilterOutputStream;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Float;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianDataOutputStream(OutputStream out) {
        super((OutputStream)new DataOutputStream(Preconditions.checkNotNull(out)));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        ((DataOutputStream)this.out).writeByte(v);
    }

    @Deprecated
    public void writeBytes(String s2) throws IOException {
        ((DataOutputStream)this.out).writeBytes(s2);
    }

    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    public void writeChars(String s2) throws IOException {
        for (int i = 0; i < s2.length(); ++i) {
            this.writeChar(s2.charAt(i));
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits((double)v));
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits((float)v));
    }

    public void writeInt(int v) throws IOException {
        this.out.write(0xFF & v);
        this.out.write(0xFF & v >> 8);
        this.out.write(0xFF & v >> 16);
        this.out.write(0xFF & v >> 24);
    }

    public void writeLong(long v) throws IOException {
        byte[] bytes = Longs.toByteArray(Long.reverseBytes((long)v));
        this.write(bytes, 0, bytes.length);
    }

    public void writeShort(int v) throws IOException {
        this.out.write(0xFF & v);
        this.out.write(0xFF & v >> 8);
    }

    public void writeUTF(String str) throws IOException {
        ((DataOutputStream)this.out).writeUTF(str);
    }

    public void close() throws IOException {
        this.out.close();
    }
}

