/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Optional;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicate;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.Iterables;
import org.rascalmpl.com.google.common.graph.Traverser;
import org.rascalmpl.com.google.common.io.ByteSink;
import org.rascalmpl.com.google.common.io.ByteSource;
import org.rascalmpl.com.google.common.io.ByteStreams;
import org.rascalmpl.com.google.common.io.CharSink;
import org.rascalmpl.com.google.common.io.CharSource;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.io.InsecureRecursiveDeleteException;
import org.rascalmpl.com.google.common.io.RecursiveDeleteOption;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InputStream;
import org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.nio.channels.Channels;
import org.rascalmpl.java.nio.channels.ReadableByteChannel;
import org.rascalmpl.java.nio.channels.SeekableByteChannel;
import org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.java.nio.file.DirectoryIteratorException;
import org.rascalmpl.java.nio.file.DirectoryStream;
import org.rascalmpl.java.nio.file.FileAlreadyExistsException;
import org.rascalmpl.java.nio.file.FileSystemException;
import org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.java.nio.file.LinkOption;
import org.rascalmpl.java.nio.file.NoSuchFileException;
import org.rascalmpl.java.nio.file.OpenOption;
import org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.java.nio.file.SecureDirectoryStream;
import org.rascalmpl.java.nio.file.attribute.BasicFileAttributeView;
import org.rascalmpl.java.nio.file.attribute.BasicFileAttributes;
import org.rascalmpl.java.nio.file.attribute.FileAttribute;
import org.rascalmpl.java.nio.file.attribute.FileTime;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.stream.Stream;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class MoreFiles
extends org.rascalmpl.java.lang.Object {
    private MoreFiles() {
    }

    public static ByteSource asByteSource(Path path, OpenOption ... options) {
        return new PathByteSource(path, options);
    }

    public static ByteSink asByteSink(Path path, OpenOption ... options) {
        return new PathByteSink(path, options);
    }

    public static CharSource asCharSource(Path path, Charset charset, OpenOption ... options) {
        return MoreFiles.asByteSource(path, options).asCharSource(charset);
    }

    public static CharSink asCharSink(Path path, Charset charset, OpenOption ... options) {
        return MoreFiles.asByteSink(path, options).asCharSink(charset);
    }

    public static ImmutableList<Path> listFiles(Path dir) throws IOException {
        ImmutableList<Path> immutableList;
        block8: {
            DirectoryStream stream = Files.newDirectoryStream((Path)dir);
            try {
                immutableList = ImmutableList.copyOf(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException e) {
                    throw e.getCause();
                }
            }
            stream.close();
        }
        return immutableList;
    }

    /*
     * Exception decompiling
     */
    public static Traverser<Path> fileTraverser() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Iterable;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Iterable<Path> fileTreeChildren(Path dir) {
        if (Files.isDirectory((Path)dir, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS})) {
            try {
                return MoreFiles.listFiles(dir);
            }
            catch (IOException e) {
                throw new DirectoryIteratorException(e);
            }
        }
        return ImmutableList.of();
    }

    public static Predicate<Path> isDirectory(LinkOption ... options) {
        final LinkOption[] optionsCopy = (LinkOption[])options.clone();
        return new Predicate<Path>(){

            @Override
            public boolean apply(Path input) {
                return Files.isDirectory((Path)input, (LinkOption[])optionsCopy);
            }

            public String toString() {
                return new StringBuilder().append((String)"org.rascalmpl.MoreFiles.isDirectory(").append(Arrays.toString((org.rascalmpl.java.lang.Object[])optionsCopy)).append((String)"org.rascalmpl.)").toString();
            }
        };
    }

    private static boolean isDirectory(SecureDirectoryStream<Path> dir, Path name, LinkOption ... options) throws IOException {
        return ((BasicFileAttributeView)dir.getFileAttributeView((org.rascalmpl.java.lang.Object)name, BasicFileAttributeView.class, options)).readAttributes().isDirectory();
    }

    public static Predicate<Path> isRegularFile(LinkOption ... options) {
        final LinkOption[] optionsCopy = (LinkOption[])options.clone();
        return new Predicate<Path>(){

            @Override
            public boolean apply(Path input) {
                return Files.isRegularFile((Path)input, (LinkOption[])optionsCopy);
            }

            public String toString() {
                return new StringBuilder().append((String)"org.rascalmpl.MoreFiles.isRegularFile(").append(Arrays.toString((org.rascalmpl.java.lang.Object[])optionsCopy)).append((String)"org.rascalmpl.)").toString();
            }
        };
    }

    public static boolean equal(Path path1, Path path2) throws IOException {
        Preconditions.checkNotNull(path1);
        Preconditions.checkNotNull(path2);
        if (Files.isSameFile((Path)path1, (Path)path2)) {
            return true;
        }
        ByteSource source1 = MoreFiles.asByteSource(path1, new OpenOption[0]);
        ByteSource source2 = MoreFiles.asByteSource(path2, new OpenOption[0]);
        long len1 = source1.sizeIfKnown().or(Long.valueOf((long)0L)).longValue();
        long len2 = source2.sizeIfKnown().or(Long.valueOf((long)0L)).longValue();
        if (len1 != 0L && len2 != 0L && len1 != len2) {
            return false;
        }
        return source1.contentEquals(source2);
    }

    public static void touch(Path path) throws IOException {
        Preconditions.checkNotNull(path);
        try {
            Files.setLastModifiedTime((Path)path, (FileTime)FileTime.fromMillis((long)System.currentTimeMillis()));
        }
        catch (NoSuchFileException e) {
            try {
                Files.createFile((Path)path, (FileAttribute[])new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    public static void createParentDirectories(Path path, FileAttribute<?> ... attrs) throws IOException {
        Path normalizedAbsolutePath = path.toAbsolutePath().normalize();
        Path parent = normalizedAbsolutePath.getParent();
        if (parent == null) {
            return;
        }
        if (!Files.isDirectory((Path)parent, (LinkOption[])new LinkOption[0])) {
            Files.createDirectories((Path)parent, attrs);
            if (!Files.isDirectory((Path)parent, (LinkOption[])new LinkOption[0])) {
                throw new IOException(new StringBuilder().append((String)"org.rascalmpl.Unable to create parent directories of ").append((org.rascalmpl.java.lang.Object)path).toString());
            }
        }
    }

    public static String getFileExtension(Path path) {
        Path name = path.getFileName();
        if (name == null) {
            return "org.rascalmpl.";
        }
        String fileName = name.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "org.rascalmpl." : fileName.substring(dotIndex + 1);
    }

    public static String getNameWithoutExtension(Path path) {
        Path name = path.getFileName();
        if (name == null) {
            return "org.rascalmpl.";
        }
        String fileName = name.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteRecursively(Path path, RecursiveDeleteOption ... options) throws IOException {
        Path parentPath = MoreFiles.getParentPath(path);
        if (parentPath == null) {
            throw new FileSystemException(path.toString(), null, (String)"org.rascalmpl.can't delete recursively");
        }
        Collection<IOException> exceptions = null;
        try {
            boolean sdsSupported;
            block10: {
                sdsSupported = false;
                DirectoryStream parent = Files.newDirectoryStream((Path)parentPath);
                try {
                    if (parent instanceof SecureDirectoryStream) {
                        sdsSupported = true;
                        exceptions = MoreFiles.deleteRecursivelySecure((SecureDirectoryStream<Path>)((SecureDirectoryStream)parent), (Path)Objects.requireNonNull((org.rascalmpl.java.lang.Object)path.getFileName()));
                    }
                    if (parent == null) break block10;
                }
                catch (Throwable throwable) {
                    if (parent == null) throw throwable;
                    try {
                        parent.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                parent.close();
            }
            if (!sdsSupported) {
                MoreFiles.checkAllowsInsecure(path, options);
                exceptions = MoreFiles.deleteRecursivelyInsecure(path);
            }
        }
        catch (IOException e) {
            if (exceptions == null) {
                throw e;
            }
            exceptions.add((org.rascalmpl.java.lang.Object)e);
        }
        if (exceptions == null) return;
        MoreFiles.throwDeleteFailed(path, exceptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteDirectoryContents(Path path, RecursiveDeleteOption ... options) throws IOException {
        Collection<IOException> exceptions;
        block9: {
            exceptions = null;
            try {
                DirectoryStream stream = Files.newDirectoryStream((Path)path);
                try {
                    if (stream instanceof SecureDirectoryStream) {
                        SecureDirectoryStream sds = (SecureDirectoryStream)stream;
                        exceptions = MoreFiles.deleteDirectoryContentsSecure((SecureDirectoryStream<Path>)sds);
                    } else {
                        MoreFiles.checkAllowsInsecure(path, options);
                        exceptions = MoreFiles.deleteDirectoryContentsInsecure((DirectoryStream<Path>)stream);
                    }
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                stream.close();
            }
            catch (IOException e) {
                if (exceptions == null) {
                    throw e;
                }
                exceptions.add((org.rascalmpl.java.lang.Object)e);
            }
        }
        if (exceptions == null) return;
        MoreFiles.throwDeleteFailed(path, exceptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private static Collection<IOException> deleteRecursivelySecure(SecureDirectoryStream<Path> dir, Path path) {
        Collection<IOException> exceptions = null;
        try {
            block7: {
                if (!MoreFiles.isDirectory(dir, path, LinkOption.NOFOLLOW_LINKS)) {
                    dir.deleteFile((org.rascalmpl.java.lang.Object)path);
                    return exceptions;
                }
                SecureDirectoryStream childDir = dir.newDirectoryStream((org.rascalmpl.java.lang.Object)path, new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
                try {
                    exceptions = MoreFiles.deleteDirectoryContentsSecure((SecureDirectoryStream<Path>)childDir);
                    if (childDir == null) break block7;
                }
                catch (Throwable throwable) {
                    if (childDir == null) throw throwable;
                    try {
                        childDir.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                childDir.close();
            }
            if (exceptions != null) return exceptions;
            dir.deleteDirectory((org.rascalmpl.java.lang.Object)path);
            return exceptions;
        }
        catch (IOException e) {
            return MoreFiles.addException(exceptions, e);
        }
    }

    @CheckForNull
    private static Collection<IOException> deleteDirectoryContentsSecure(SecureDirectoryStream<Path> dir) {
        Collection<IOException> exceptions = null;
        try {
            for (Path path : dir) {
                exceptions = MoreFiles.concat(exceptions, MoreFiles.deleteRecursivelySecure(dir, path.getFileName()));
            }
            return exceptions;
        }
        catch (DirectoryIteratorException e) {
            return MoreFiles.addException(exceptions, e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private static Collection<IOException> deleteRecursivelyInsecure(Path path) {
        Collection<IOException> exceptions = null;
        try {
            block7: {
                if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS})) {
                    DirectoryStream stream = Files.newDirectoryStream((Path)path);
                    try {
                        exceptions = MoreFiles.deleteDirectoryContentsInsecure((DirectoryStream<Path>)stream);
                        if (stream == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    stream.close();
                }
            }
            if (exceptions != null) return exceptions;
            Files.delete((Path)path);
            return exceptions;
        }
        catch (IOException e) {
            return MoreFiles.addException(exceptions, e);
        }
    }

    @CheckForNull
    private static Collection<IOException> deleteDirectoryContentsInsecure(DirectoryStream<Path> dir) {
        Collection<IOException> exceptions = null;
        try {
            for (Path entry : dir) {
                exceptions = MoreFiles.concat(exceptions, MoreFiles.deleteRecursivelyInsecure(entry));
            }
            return exceptions;
        }
        catch (DirectoryIteratorException e) {
            return MoreFiles.addException(exceptions, e.getCause());
        }
    }

    @CheckForNull
    private static Path getParentPath(Path path) {
        Path parent = path.getParent();
        if (parent != null) {
            return parent;
        }
        if (path.getNameCount() == 0) {
            return null;
        }
        return path.getFileSystem().getPath((String)"org.rascalmpl..", new String[0]);
    }

    private static void checkAllowsInsecure(Path path, RecursiveDeleteOption[] options) throws InsecureRecursiveDeleteException {
        if (!Arrays.asList((org.rascalmpl.java.lang.Object[])options).contains((org.rascalmpl.java.lang.Object)RecursiveDeleteOption.ALLOW_INSECURE)) {
            throw new InsecureRecursiveDeleteException(path.toString());
        }
    }

    private static Collection<IOException> addException(@CheckForNull Collection<IOException> exceptions, IOException e) {
        if (exceptions == null) {
            exceptions = new ArrayList();
        }
        exceptions.add((org.rascalmpl.java.lang.Object)e);
        return exceptions;
    }

    @CheckForNull
    private static Collection<IOException> concat(@CheckForNull Collection<IOException> exceptions, @CheckForNull Collection<IOException> other) {
        if (exceptions == null) {
            return other;
        }
        if (other != null) {
            exceptions.addAll(other);
        }
        return exceptions;
    }

    private static void throwDeleteFailed(Path path, Collection<IOException> exceptions) throws FileSystemException {
        NoSuchFileException pathNotFound = MoreFiles.pathNotFound(path, exceptions);
        if (pathNotFound != null) {
            throw pathNotFound;
        }
        FileSystemException deleteFailed = new FileSystemException(path.toString(), null, (String)"org.rascalmpl.failed to delete one or more files; see suppressed exceptions for details");
        for (IOException e : exceptions) {
            deleteFailed.addSuppressed((Throwable)((Object)e));
        }
        throw deleteFailed;
    }

    @CheckForNull
    private static NoSuchFileException pathNotFound(Path path, Collection<IOException> exceptions) {
        if (exceptions.size() != 1) {
            return null;
        }
        IOException exception = Iterables.getOnlyElement(exceptions);
        if (!(exception instanceof NoSuchFileException)) {
            return null;
        }
        NoSuchFileException noSuchFileException = (NoSuchFileException)((Object)exception);
        String exceptionFile = noSuchFileException.getFile();
        if (exceptionFile == null) {
            return null;
        }
        Path parentPath = MoreFiles.getParentPath(path);
        if (parentPath == null) {
            return null;
        }
        Path pathResolvedFromParent = parentPath.resolve((Path)Objects.requireNonNull((org.rascalmpl.java.lang.Object)path.getFileName()));
        if (exceptionFile.equals((org.rascalmpl.java.lang.Object)pathResolvedFromParent.toString())) {
            return noSuchFileException;
        }
        return null;
    }

    private static final class PathByteSink
    extends ByteSink {
        private final Path path;
        private final OpenOption[] options;

        private PathByteSink(Path path, OpenOption ... options) {
            this.path = Preconditions.checkNotNull(path);
            this.options = (OpenOption[])options.clone();
        }

        @Override
        public OutputStream openStream() throws IOException {
            return Files.newOutputStream((Path)this.path, (OpenOption[])this.options);
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.MoreFiles.asByteSink(").append((org.rascalmpl.java.lang.Object)this.path).append((String)"org.rascalmpl., ").append(Arrays.toString((org.rascalmpl.java.lang.Object[])this.options)).append((String)"org.rascalmpl.)").toString();
        }
    }

    private static final class PathByteSource
    extends ByteSource {
        private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
        private final Path path;
        private final OpenOption[] options;
        private final boolean followLinks;

        private PathByteSource(Path path, OpenOption ... options) {
            this.path = Preconditions.checkNotNull(path);
            this.options = (OpenOption[])options.clone();
            this.followLinks = PathByteSource.followLinks(this.options);
        }

        private static boolean followLinks(OpenOption[] options) {
            for (OpenOption option : options) {
                if (option != LinkOption.NOFOLLOW_LINKS) continue;
                return false;
            }
            return true;
        }

        @Override
        public InputStream openStream() throws IOException {
            return Files.newInputStream((Path)this.path, (OpenOption[])this.options);
        }

        private BasicFileAttributes readAttributes() throws IOException {
            LinkOption[] linkOptionArray;
            if (this.followLinks) {
                linkOptionArray = FOLLOW_LINKS;
            } else {
                LinkOption[] linkOptionArray2 = new LinkOption[1];
                linkOptionArray = linkOptionArray2;
                linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
            }
            return Files.readAttributes((Path)this.path, BasicFileAttributes.class, (LinkOption[])linkOptionArray);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            BasicFileAttributes attrs;
            try {
                attrs = this.readAttributes();
            }
            catch (IOException e) {
                return Optional.absent();
            }
            if (attrs.isDirectory() || attrs.isSymbolicLink()) {
                return Optional.absent();
            }
            return Optional.of(Long.valueOf((long)attrs.size()));
        }

        @Override
        public long size() throws IOException {
            BasicFileAttributes attrs = this.readAttributes();
            if (attrs.isDirectory()) {
                throw new IOException((String)"org.rascalmpl.can't read: is a directory");
            }
            if (attrs.isSymbolicLink()) {
                throw new IOException((String)"org.rascalmpl.can't read: is a symbolic link");
            }
            return attrs.size();
        }

        @Override
        public byte[] read() throws IOException {
            byte[] byArray;
            block5: {
                SeekableByteChannel channel = Files.newByteChannel((Path)this.path, (OpenOption[])this.options);
                try {
                    byArray = ByteStreams.toByteArray(Channels.newInputStream((ReadableByteChannel)channel), channel.size());
                    if (channel == null) break block5;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return byArray;
        }

        @Override
        public CharSource asCharSource(Charset charset) {
            if (this.options.length == 0) {
                return new ByteSource.AsCharSource(charset){

                    @Override
                    public Stream<String> lines() throws IOException {
                        return Files.lines((Path)path, (Charset)this.charset);
                    }
                };
            }
            return super.asCharSource(charset);
        }

        public String toString() {
            return new StringBuilder().append((String)"org.rascalmpl.MoreFiles.asByteSource(").append((org.rascalmpl.java.lang.Object)this.path).append((String)"org.rascalmpl., ").append(Arrays.toString((org.rascalmpl.java.lang.Object[])this.options)).append((String)"org.rascalmpl.)").toString();
        }
    }
}

