/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.io.Java8Compatibility;
import org.rascalmpl.com.google.common.primitives.UnsignedBytes;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.io.InputStream;
import org.rascalmpl.java.io.Reader;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.nio.Buffer;
import org.rascalmpl.java.nio.ByteBuffer;
import org.rascalmpl.java.nio.CharBuffer;
import org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.java.nio.charset.CharsetEncoder;
import org.rascalmpl.java.nio.charset.CoderResult;
import org.rascalmpl.java.nio.charset.CodingErrorAction;
import org.rascalmpl.java.util.Arrays;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final CharsetEncoder encoder;
    private final byte[] singleByte = new byte[1];
    private CharBuffer charBuffer;
    private ByteBuffer byteBuffer;
    private boolean endOfInput;
    private boolean draining;
    private boolean doneFlushing;

    ReaderInputStream(Reader reader, Charset charset, int bufferSize) {
        this(reader, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), bufferSize);
    }

    ReaderInputStream(Reader reader, CharsetEncoder encoder, int bufferSize) {
        this.reader = Preconditions.checkNotNull(reader);
        this.encoder = Preconditions.checkNotNull(encoder);
        Preconditions.checkArgument(bufferSize > 0, (String)"org.rascalmpl.bufferSize must be positive: %s", bufferSize);
        encoder.reset();
        this.charBuffer = CharBuffer.allocate((int)bufferSize);
        Java8Compatibility.flip((Buffer)this.charBuffer);
        this.byteBuffer = ByteBuffer.allocate((int)bufferSize);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read() throws IOException {
        return this.read(this.singleByte) == 1 ? UnsignedBytes.toInt(this.singleByte[0]) : -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        CoderResult result;
        Preconditions.checkPositionIndexes(off, off + len, b.length);
        if (len == 0) {
            return 0;
        }
        int totalBytesRead = 0;
        boolean doneEncoding = this.endOfInput;
        block0: while (true) {
            if (this.draining) {
                if ((totalBytesRead += this.drain(b, off + totalBytesRead, len - totalBytesRead)) == len || this.doneFlushing) {
                    return totalBytesRead > 0 ? totalBytesRead : -1;
                }
                this.draining = false;
                Java8Compatibility.clear((Buffer)this.byteBuffer);
            }
            while (true) {
                if ((result = this.doneFlushing ? CoderResult.UNDERFLOW : (doneEncoding ? this.encoder.flush(this.byteBuffer) : this.encoder.encode(this.charBuffer, this.byteBuffer, this.endOfInput))).isOverflow()) {
                    this.startDraining(true);
                    continue block0;
                }
                if (result.isUnderflow()) {
                    if (doneEncoding) {
                        this.doneFlushing = true;
                        this.startDraining(false);
                        continue block0;
                    }
                    if (this.endOfInput) {
                        doneEncoding = true;
                        continue;
                    }
                    this.readMoreChars();
                    continue;
                }
                if (result.isError()) break block0;
            }
            break;
        }
        result.throwException();
        return 0;
    }

    private static CharBuffer grow(CharBuffer buf) {
        char[] copy = Arrays.copyOf((char[])buf.array(), (int)(buf.capacity() * 2));
        CharBuffer bigger = CharBuffer.wrap((char[])copy);
        Java8Compatibility.position((Buffer)bigger, buf.position());
        Java8Compatibility.limit((Buffer)bigger, buf.limit());
        return bigger;
    }

    private void readMoreChars() throws IOException {
        if (ReaderInputStream.availableCapacity((Buffer)this.charBuffer) == 0) {
            if (this.charBuffer.position() > 0) {
                Java8Compatibility.flip((Buffer)this.charBuffer.compact());
            } else {
                this.charBuffer = ReaderInputStream.grow(this.charBuffer);
            }
        }
        int limit = this.charBuffer.limit();
        int numChars = this.reader.read(this.charBuffer.array(), limit, ReaderInputStream.availableCapacity((Buffer)this.charBuffer));
        if (numChars == -1) {
            this.endOfInput = true;
        } else {
            Java8Compatibility.limit((Buffer)this.charBuffer, limit + numChars);
        }
    }

    private static int availableCapacity(Buffer buffer) {
        return buffer.capacity() - buffer.limit();
    }

    private void startDraining(boolean overflow) {
        Java8Compatibility.flip((Buffer)this.byteBuffer);
        if (overflow && this.byteBuffer.remaining() == 0) {
            this.byteBuffer = ByteBuffer.allocate((int)(this.byteBuffer.capacity() * 2));
        } else {
            this.draining = true;
        }
    }

    private int drain(byte[] b, int off, int len) {
        int remaining = Math.min((int)len, (int)this.byteBuffer.remaining());
        this.byteBuffer.get(b, off, remaining);
        return remaining;
    }
}

