/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.io;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.StandardSystemProperty;
import org.rascalmpl.com.google.common.base.Throwables;
import org.rascalmpl.com.google.common.io.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.io.IgnoreJRERequirement;
import org.rascalmpl.java.io.File;
import org.rascalmpl.java.io.IOException;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.NoSuchFieldException;
import org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.nio.file.FileSystems;
import org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.java.nio.file.Paths;
import org.rascalmpl.java.nio.file.attribute.FileAttribute;
import org.rascalmpl.java.nio.file.attribute.PosixFilePermissions;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
abstract class TempFileCreator
extends org.rascalmpl.java.lang.Object {
    static final TempFileCreator INSTANCE = TempFileCreator.pickSecureCreator();

    abstract File createTempDir();

    abstract File createTempFile(String var1) throws IOException;

    private static TempFileCreator pickSecureCreator() {
        try {
            Class.forName((String)"org.rascalmpl.java.nio.file.Path");
            return new JavaNioCreator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                int version = ((Integer)Class.forName((String)"org.rascalmpl.android.os.Build$VERSION").getField((String)"org.rascalmpl.SDK_INT").get(null)).intValue();
                int jellyBean = ((Integer)Class.forName((String)"org.rascalmpl.android.os.Build$VERSION_CODES").getField((String)"org.rascalmpl.JELLY_BEAN").get(null)).intValue();
                if (version < jellyBean) {
                    return new ThrowingCreator();
                }
            }
            catch (NoSuchFieldException e) {
                return new ThrowingCreator();
            }
            catch (ClassNotFoundException e) {
                return new ThrowingCreator();
            }
            catch (IllegalAccessException e) {
                return new ThrowingCreator();
            }
            return new JavaIoCreator();
        }
    }

    @IgnoreJRERequirement
    @VisibleForTesting
    static void testMakingUserPermissionsFromScratch() throws IOException {
        FileAttribute<?> unused = JavaNioCreator.userPermissions().get();
    }

    private TempFileCreator() {
    }

    private static final class ThrowingCreator
    extends TempFileCreator {
        private static final String MESSAGE = "org.rascalmpl.Guava cannot securely create temporary files or directories under SDK versions before Jelly Bean. You can create one yourself, either in the insecure default directory or in a more secure directory, such as context.getCacheDir(). For more information, see the Javadoc for Files.createTempDir().";

        private ThrowingCreator() {
        }

        @Override
        File createTempDir() {
            throw new IllegalStateException((String)"org.rascalmpl.Guava cannot securely create temporary files or directories under SDK versions before Jelly Bean. You can create one yourself, either in the insecure default directory or in a more secure directory, such as context.getCacheDir(). For more information, see the Javadoc for Files.createTempDir().");
        }

        @Override
        File createTempFile(String prefix) throws IOException {
            throw new IOException((String)"org.rascalmpl.Guava cannot securely create temporary files or directories under SDK versions before Jelly Bean. You can create one yourself, either in the insecure default directory or in a more secure directory, such as context.getCacheDir(). For more information, see the Javadoc for Files.createTempDir().");
        }
    }

    private static final class JavaIoCreator
    extends TempFileCreator {
        private static final int TEMP_DIR_ATTEMPTS = 10000;

        private JavaIoCreator() {
        }

        @Override
        File createTempDir() {
            File baseDir = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
            String baseName = new StringBuilder().append(System.currentTimeMillis()).append((String)"org.rascalmpl.-").toString();
            for (int counter = 0; counter < 10000; ++counter) {
                File tempDir = new File(baseDir, new StringBuilder().append(baseName).append(counter).toString());
                if (!tempDir.mkdir()) continue;
                return tempDir;
            }
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Failed to create directory within 10000 attempts (tried ").append(baseName).append((String)"org.rascalmpl.0 to ").append(baseName).append(9999).append(')').toString());
        }

        @Override
        File createTempFile(String prefix) throws IOException {
            return File.createTempFile((String)prefix, null, null);
        }
    }

    @IgnoreJRERequirement
    private static final class JavaNioCreator
    extends TempFileCreator {
        private static final PermissionSupplier filePermissions;
        private static final PermissionSupplier directoryPermissions;

        private JavaNioCreator() {
        }

        @Override
        File createTempDir() {
            try {
                return Files.createTempDirectory((Path)Paths.get((String)StandardSystemProperty.JAVA_IO_TMPDIR.value(), (String[])new String[0]), null, (FileAttribute[])new FileAttribute[]{directoryPermissions.get()}).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException((String)"org.rascalmpl.Failed to create directory", (Throwable)((Object)e));
            }
        }

        @Override
        File createTempFile(String prefix) throws IOException {
            return Files.createTempFile((Path)Paths.get((String)StandardSystemProperty.JAVA_IO_TMPDIR.value(), (String[])new String[0]), (String)prefix, null, (FileAttribute[])new FileAttribute[]{filePermissions.get()}).toFile();
        }

        /*
         * Exception decompiling
         */
        private static PermissionSupplier userPermissions() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/java/nio/file/attribute/FileAttribute;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static String getUsername() {
            String fromSystemProperty = (String)Objects.requireNonNull((org.rascalmpl.java.lang.Object)StandardSystemProperty.USER_NAME.value());
            try {
                Class processHandleClass = Class.forName((String)"org.rascalmpl.java.lang.ProcessHandle");
                Class processHandleInfoClass = Class.forName((String)"org.rascalmpl.java.lang.ProcessHandle$Info");
                Class optionalClass = Class.forName((String)"org.rascalmpl.java.util.Optional");
                Method currentMethod = processHandleClass.getMethod((String)"org.rascalmpl.current", new Class[0]);
                Method infoMethod = processHandleClass.getMethod((String)"org.rascalmpl.info", new Class[0]);
                Method userMethod = processHandleInfoClass.getMethod((String)"org.rascalmpl.user", new Class[0]);
                Method orElseMethod = optionalClass.getMethod((String)"org.rascalmpl.orElse", new Class[]{org.rascalmpl.java.lang.Object.class});
                org.rascalmpl.java.lang.Object current = currentMethod.invoke(null, new org.rascalmpl.java.lang.Object[0]);
                org.rascalmpl.java.lang.Object info = infoMethod.invoke(current, new org.rascalmpl.java.lang.Object[0]);
                org.rascalmpl.java.lang.Object user = userMethod.invoke(info, new org.rascalmpl.java.lang.Object[0]);
                return (String)Objects.requireNonNull((org.rascalmpl.java.lang.Object)orElseMethod.invoke(user, new org.rascalmpl.java.lang.Object[]{fromSystemProperty}));
            }
            catch (ClassNotFoundException runningUnderAndroidOrJava8) {
                return fromSystemProperty;
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfUnchecked(e.getCause());
                return fromSystemProperty;
            }
            catch (NoSuchMethodException shouldBeImpossible) {
                return fromSystemProperty;
            }
            catch (IllegalAccessException shouldBeImpossible) {
                return fromSystemProperty;
            }
        }

        private static /* synthetic */ FileAttribute lambda$userPermissions$4(IOException e) throws IOException {
            throw new IOException((String)"org.rascalmpl.Could not find user", (Throwable)((Object)e));
        }

        private static /* synthetic */ FileAttribute lambda$userPermissions$3(FileAttribute attribute) throws IOException {
            return attribute;
        }

        private static /* synthetic */ FileAttribute lambda$static$2() throws IOException {
            throw new IOException(new StringBuilder().append((String)"org.rascalmpl.unrecognized FileSystem type ").append((org.rascalmpl.java.lang.Object)FileSystems.getDefault()).toString());
        }

        private static /* synthetic */ FileAttribute lambda$static$1() throws IOException {
            return PosixFilePermissions.asFileAttribute((Set)PosixFilePermissions.fromString((String)"org.rascalmpl.rwx------"));
        }

        private static /* synthetic */ FileAttribute lambda$static$0() throws IOException {
            return PosixFilePermissions.asFileAttribute((Set)PosixFilePermissions.fromString((String)"org.rascalmpl.rw-------"));
        }

        /*
         * Exception decompiling
         */
        static {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/java/nio/file/attribute/FileAttribute;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @IgnoreJRERequirement
        private static interface PermissionSupplier {
            public FileAttribute<?> get() throws IOException;
        }
    }
}

