/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.primitives;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Booleans
extends Object {
    private Booleans() {
    }

    public static Comparator<Boolean> trueFirst() {
        return BooleanComparator.TRUE_FIRST;
    }

    public static Comparator<Boolean> falseFirst() {
        return BooleanComparator.FALSE_FIRST;
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int compare(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    public static boolean contains(boolean[] array, boolean target) {
        for (boolean value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(boolean[] array, boolean target) {
        return Booleans.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(boolean[] array, boolean target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean[] target) {
        Preconditions.checkNotNull(array, (Object)"org.rascalmpl.array");
        Preconditions.checkNotNull(target, (Object)"org.rascalmpl.target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean target) {
        return Booleans.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(boolean[] array, boolean target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] concat(boolean[] ... arrays) {
        int length = 0;
        for (boolean[] array : arrays) {
            length += array.length;
        }
        boolean[] result = new boolean[length];
        int pos = 0;
        for (boolean[] array : arrays) {
            System.arraycopy((Object)array, (int)0, (Object)result, (int)pos, (int)array.length);
            pos += array.length;
        }
        return result;
    }

    public static boolean[] ensureCapacity(boolean[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, (String)"org.rascalmpl.Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, (String)"org.rascalmpl.Invalid padding: %s", padding);
        return array.length < minLength ? Arrays.copyOf((boolean[])array, (int)(minLength + padding)) : array;
    }

    public static String join(String separator, boolean ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "org.rascalmpl.";
        }
        StringBuilder builder = new StringBuilder(array.length * 7);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static boolean[] toArray(Collection<Boolean> collection) {
        if (collection instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)collection).toBooleanArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        boolean[] array = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Boolean)Preconditions.checkNotNull(boxedArray[i])).booleanValue();
        }
        return array;
    }

    public static List<Boolean> asList(boolean ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(backingArray);
    }

    public static int countTrue(boolean ... values) {
        int count = 0;
        for (boolean value : values) {
            if (!value) continue;
            ++count;
        }
        return count;
    }

    public static void reverse(boolean[] array) {
        Preconditions.checkNotNull(array);
        Booleans.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            boolean tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void rotate(boolean[] array, int distance) {
        Booleans.rotate(array, distance, 0, array.length);
    }

    public static void rotate(boolean[] array, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        if (array.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m4 = -distance % length;
        m4 = m4 < 0 ? m4 + length : m4;
        int newFirstIndex = m4 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Booleans.reverse(array, fromIndex, newFirstIndex);
        Booleans.reverse(array, newFirstIndex, toIndex);
        Booleans.reverse(array, fromIndex, toIndex);
    }

    @GwtCompatible
    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements RandomAccess,
    Serializable {
        final boolean[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        BooleanArrayAsList(boolean[] array) {
            this(array, 0, array.length);
        }

        BooleanArrayAsList(boolean[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isEmpty() {
            return false;
        }

        public Boolean get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return Boolean.valueOf((boolean)this.array[this.start + index]);
        }

        public boolean contains(@CheckForNull Object target) {
            return target instanceof Boolean && Booleans.indexOf(this.array, ((Boolean)target).booleanValue(), this.start, this.end) != -1;
        }

        public int indexOf(@CheckForNull Object target) {
            int i;
            if (target instanceof Boolean && (i = Booleans.indexOf(this.array, ((Boolean)target).booleanValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public int lastIndexOf(@CheckForNull Object target) {
            int i;
            if (target instanceof Boolean && (i = Booleans.lastIndexOf(this.array, ((Boolean)target).booleanValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public Boolean set(int index, Boolean element) {
            Preconditions.checkElementIndex(index, this.size());
            boolean oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).booleanValue();
            return Boolean.valueOf((boolean)oldValue);
        }

        public List<Boolean> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new BooleanArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                BooleanArrayAsList that = (BooleanArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Booleans.hashCode(this.array[i]);
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 7);
            builder.append((String)(this.array[this.start] ? "org.rascalmpl.[true" : "org.rascalmpl.[false"));
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append((String)(this.array[i] ? "org.rascalmpl., true" : "org.rascalmpl., false"));
            }
            return builder.append(']').toString();
        }

        boolean[] toBooleanArray() {
            return Arrays.copyOfRange((boolean[])this.array, (int)this.start, (int)this.end);
        }
    }

    private static final class LexicographicalComparator
    extends Enum<LexicographicalComparator>
    implements Comparator<boolean[]> {
        public static final /* enum */ LexicographicalComparator INSTANCE = new LexicographicalComparator((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ LexicographicalComparator[] $VALUES;

        public static LexicographicalComparator[] values() {
            return (LexicographicalComparator[])$VALUES.clone();
        }

        public static LexicographicalComparator valueOf(String name) {
            return (LexicographicalComparator)Enum.valueOf(LexicographicalComparator.class, (String)name);
        }

        private LexicographicalComparator() {
            super((String)string, n);
        }

        public int compare(boolean[] left, boolean[] right) {
            int minLength = Math.min((int)left.length, (int)right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Booleans.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "org.rascalmpl.Booleans.lexicographicalComparator()";
        }

        static {
            $VALUES = new LexicographicalComparator[]{INSTANCE};
        }
    }

    private static final class BooleanComparator
    extends Enum<BooleanComparator>
    implements Comparator<Boolean> {
        public static final /* enum */ BooleanComparator TRUE_FIRST = new BooleanComparator((String)"org.rascalmpl.TRUE_FIRST", 0, 1, (String)"org.rascalmpl.Booleans.trueFirst()");
        public static final /* enum */ BooleanComparator FALSE_FIRST = new BooleanComparator((String)"org.rascalmpl.FALSE_FIRST", 1, -1, (String)"org.rascalmpl.Booleans.falseFirst()");
        private final int trueValue;
        private final String toString;
        private static final /* synthetic */ BooleanComparator[] $VALUES;

        public static BooleanComparator[] values() {
            return (BooleanComparator[])$VALUES.clone();
        }

        public static BooleanComparator valueOf(String name) {
            return (BooleanComparator)Enum.valueOf(BooleanComparator.class, (String)name);
        }

        private BooleanComparator(int trueValue, String toString) {
            super((String)string, n);
            this.trueValue = trueValue;
            this.toString = toString;
        }

        public int compare(Boolean a, Boolean b) {
            int aVal = a.booleanValue() ? this.trueValue : 0;
            int bVal = b.booleanValue() ? this.trueValue : 0;
            return bVal - aVal;
        }

        public String toString() {
            return this.toString;
        }

        static {
            $VALUES = new BooleanComparator[]{TRUE_FIRST, FALSE_FIRST};
        }
    }
}

