/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.primitives;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.primitives.Longs;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.Immutable;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.java.util.function.LongConsumer;
import org.rascalmpl.java.util.stream.LongStream;
import org.rascalmpl.javax.annotation.CheckForNull;

@Immutable
@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class ImmutableLongArray
extends org.rascalmpl.java.lang.Object
implements Serializable {
    private static final ImmutableLongArray EMPTY = new ImmutableLongArray(new long[0]);
    private final long[] array;
    private final transient int start;
    private final int end;

    public static ImmutableLongArray of() {
        return EMPTY;
    }

    public static ImmutableLongArray of(long e0) {
        return new ImmutableLongArray(new long[]{e0});
    }

    public static ImmutableLongArray of(long e0, long e1) {
        return new ImmutableLongArray(new long[]{e0, e1});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2) {
        return new ImmutableLongArray(new long[]{e0, e1, e2});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2, long e3) {
        return new ImmutableLongArray(new long[]{e0, e1, e2, e3});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2, long e3, long e4) {
        return new ImmutableLongArray(new long[]{e0, e1, e2, e3, e4});
    }

    public static ImmutableLongArray of(long e0, long e1, long e2, long e3, long e4, long e5) {
        return new ImmutableLongArray(new long[]{e0, e1, e2, e3, e4, e5});
    }

    public static ImmutableLongArray of(long first, long ... rest) {
        Preconditions.checkArgument(rest.length <= 0x7FFFFFFE, (org.rascalmpl.java.lang.Object)"org.rascalmpl.the total number of elements must fit in an int");
        long[] array = new long[rest.length + 1];
        array[0] = first;
        System.arraycopy((org.rascalmpl.java.lang.Object)rest, (int)0, (org.rascalmpl.java.lang.Object)array, (int)1, (int)rest.length);
        return new ImmutableLongArray(array);
    }

    public static ImmutableLongArray copyOf(long[] values) {
        return values.length == 0 ? EMPTY : new ImmutableLongArray(Arrays.copyOf((long[])values, (int)values.length));
    }

    public static ImmutableLongArray copyOf(Collection<Long> values) {
        return values.isEmpty() ? EMPTY : new ImmutableLongArray(Longs.toArray(values));
    }

    public static ImmutableLongArray copyOf(Iterable<Long> values) {
        if (values instanceof Collection) {
            return ImmutableLongArray.copyOf((Collection<Long>)((Collection)values));
        }
        return ImmutableLongArray.builder().addAll(values).build();
    }

    public static ImmutableLongArray copyOf(LongStream stream) {
        long[] array = stream.toArray();
        return array.length == 0 ? EMPTY : new ImmutableLongArray(array);
    }

    public static Builder builder(int initialCapacity) {
        Preconditions.checkArgument(initialCapacity >= 0, (String)"org.rascalmpl.Invalid initialCapacity: %s", initialCapacity);
        return new Builder(initialCapacity);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableLongArray(long[] array) {
        this(array, 0, array.length);
    }

    private ImmutableLongArray(long[] array, int start, int end) {
        this.array = array;
        this.start = start;
        this.end = end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public long get(int index) {
        Preconditions.checkElementIndex(index, this.length());
        return this.array[this.start + index];
    }

    public int indexOf(long target) {
        for (int i = this.start; i < this.end; ++i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    public int lastIndexOf(long target) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    public boolean contains(long target) {
        return this.indexOf(target) >= 0;
    }

    public void forEach(LongConsumer consumer) {
        Preconditions.checkNotNull(consumer);
        for (int i = this.start; i < this.end; ++i) {
            consumer.accept(this.array[i]);
        }
    }

    public LongStream stream() {
        return Arrays.stream((long[])this.array, (int)this.start, (int)this.end);
    }

    public long[] toArray() {
        return Arrays.copyOfRange((long[])this.array, (int)this.start, (int)this.end);
    }

    public ImmutableLongArray subArray(int startIndex, int endIndex) {
        Preconditions.checkPositionIndexes(startIndex, endIndex, this.length());
        return startIndex == endIndex ? EMPTY : new ImmutableLongArray(this.array, this.start + startIndex, this.start + endIndex);
    }

    private Spliterator.OfLong spliterator() {
        return Spliterators.spliterator((long[])this.array, (int)this.start, (int)this.end, (int)1040);
    }

    public List<Long> asList() {
        return new AsList(this);
    }

    public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableLongArray)) {
            return false;
        }
        ImmutableLongArray that = (ImmutableLongArray)object;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i) == that.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (int i = this.start; i < this.end; ++i) {
            hash *= 31;
            hash += Longs.hashCode(this.array[i]);
        }
        return hash;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "org.rascalmpl.[]";
        }
        StringBuilder builder = new StringBuilder(this.length() * 5);
        builder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            builder.append((String)"org.rascalmpl., ").append(this.array[i]);
        }
        builder.append(']');
        return builder.toString();
    }

    public ImmutableLongArray trimmed() {
        return this.isPartialView() ? new ImmutableLongArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    org.rascalmpl.java.lang.Object writeReplace() {
        return this.trimmed();
    }

    org.rascalmpl.java.lang.Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        private final ImmutableLongArray parent;

        private AsList(ImmutableLongArray parent) {
            this.parent = parent;
        }

        public int size() {
            return this.parent.length();
        }

        public Long get(int index) {
            return Long.valueOf((long)this.parent.get(index));
        }

        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object target) {
            return this.indexOf(target) >= 0;
        }

        public int indexOf(@CheckForNull org.rascalmpl.java.lang.Object target) {
            return target instanceof Long ? this.parent.indexOf(((Long)target).longValue()) : -1;
        }

        public int lastIndexOf(@CheckForNull org.rascalmpl.java.lang.Object target) {
            return target instanceof Long ? this.parent.lastIndexOf(((Long)target).longValue()) : -1;
        }

        public List<Long> subList(int fromIndex, int toIndex) {
            return this.parent.subArray(fromIndex, toIndex).asList();
        }

        public Spliterator<Long> spliterator() {
            return this.parent.spliterator();
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object object) {
            if (object instanceof AsList) {
                AsList that = (AsList)object;
                return this.parent.equals(that.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List that = (List)object;
            if (this.size() != that.size()) {
                return false;
            }
            int i = this.parent.start;
            for (org.rascalmpl.java.lang.Object element : that) {
                if (element instanceof Long && this.parent.array[i++] == ((Long)element).longValue()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.parent.hashCode();
        }

        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder
    extends org.rascalmpl.java.lang.Object {
        private long[] array;
        private int count = 0;

        Builder(int initialCapacity) {
            this.array = new long[initialCapacity];
        }

        @CanIgnoreReturnValue
        public Builder add(long value) {
            this.ensureRoomFor(1);
            this.array[this.count] = value;
            ++this.count;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(long[] values) {
            this.ensureRoomFor(values.length);
            System.arraycopy((org.rascalmpl.java.lang.Object)values, (int)0, (org.rascalmpl.java.lang.Object)this.array, (int)this.count, (int)values.length);
            this.count += values.length;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Iterable<Long> values) {
            if (values instanceof Collection) {
                return this.addAll((Collection<Long>)((Collection)values));
            }
            for (Long value : values) {
                this.add(value.longValue());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Collection<Long> values) {
            this.ensureRoomFor(values.size());
            for (Long value : values) {
                this.array[this.count++] = value.longValue();
            }
            return this;
        }

        /*
         * Exception decompiling
         */
        @CanIgnoreReturnValue
        public Builder addAll(LongStream stream) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (J)V
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @CanIgnoreReturnValue
        public Builder addAll(ImmutableLongArray values) {
            this.ensureRoomFor(values.length());
            System.arraycopy((org.rascalmpl.java.lang.Object)values.array, (int)values.start, (org.rascalmpl.java.lang.Object)this.array, (int)this.count, (int)values.length());
            this.count += values.length();
            return this;
        }

        private void ensureRoomFor(int numberToAdd) {
            int newCount = this.count + numberToAdd;
            if (newCount > this.array.length) {
                this.array = Arrays.copyOf((long[])this.array, (int)Builder.expandedCapacity(this.array.length, newCount));
            }
        }

        private static int expandedCapacity(int oldCapacity, int minCapacity) {
            if (minCapacity < 0) {
                throw new AssertionError((org.rascalmpl.java.lang.Object)"org.rascalmpl.cannot store more than MAX_VALUE elements");
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = org.rascalmpl.java.lang.Integer.highestOneBit((int)(minCapacity - 1)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        public ImmutableLongArray build() {
            return this.count == 0 ? EMPTY : new ImmutableLongArray(this.array, 0, this.count);
        }
    }
}

