/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.primitives;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.base.Converter;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.primitives.IntsMethodsForWeb;
import org.rascalmpl.com.google.common.primitives.Longs;
import org.rascalmpl.java.io.Serializable;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Number;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.util.AbstractList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Comparator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.RandomAccess;
import org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.java.util.Spliterators;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Ints
extends IntsMethodsForWeb {
    public static final int BYTES = 4;
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private Ints() {
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int checkedCast(long value) {
        int result = (int)value;
        Preconditions.checkArgument((long)result == value, (String)"org.rascalmpl.Out of range: %s", value);
        return result;
    }

    public static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static int compare(int a, int b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static boolean contains(int[] array, int target) {
        for (int value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(int[] array, int target) {
        return Ints.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(int[] array, int target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int[] target) {
        Preconditions.checkNotNull(array, (org.rascalmpl.java.lang.Object)"org.rascalmpl.array");
        Preconditions.checkNotNull(target, (org.rascalmpl.java.lang.Object)"org.rascalmpl.target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int target) {
        return Ints.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(int[] array, int target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    @GwtIncompatible(value="org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int min(int ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min2 = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min2) continue;
            min2 = array[i];
        }
        return min2;
    }

    @GwtIncompatible(value="org.rascalmpl.Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int max(int ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static int constrainToRange(int value, int min2, int max) {
        Preconditions.checkArgument(min2 <= max, (String)"org.rascalmpl.min (%s) must be less than or equal to max (%s)", min2, max);
        return Math.min((int)Math.max((int)value, (int)min2), (int)max);
    }

    public static int[] concat(int[] ... arrays) {
        int length = 0;
        for (int[] array : arrays) {
            length += array.length;
        }
        int[] result = new int[length];
        int pos = 0;
        for (int[] array : arrays) {
            System.arraycopy((org.rascalmpl.java.lang.Object)array, (int)0, (org.rascalmpl.java.lang.Object)result, (int)pos, (int)array.length);
            pos += array.length;
        }
        return result;
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static int fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 4, (String)"org.rascalmpl.array too small: %s < %s", bytes.length, 4);
        return Ints.fromBytes(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    public static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static Converter<String, org.rascalmpl.java.lang.Integer> stringConverter() {
        return IntConverter.INSTANCE;
    }

    public static int[] ensureCapacity(int[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, (String)"org.rascalmpl.Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, (String)"org.rascalmpl.Invalid padding: %s", padding);
        return array.length < minLength ? Arrays.copyOf((int[])array, (int)(minLength + padding)) : array;
    }

    public static String join(String separator, int ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "org.rascalmpl.";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(int[] array) {
        Preconditions.checkNotNull(array);
        Ints.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(int[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort((int[])array, (int)fromIndex, (int)toIndex);
        Ints.reverse(array, fromIndex, toIndex);
    }

    public static void reverse(int[] array) {
        Preconditions.checkNotNull(array);
        Ints.reverse(array, 0, array.length);
    }

    public static void reverse(int[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            int tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    public static void rotate(int[] array, int distance) {
        Ints.rotate(array, distance, 0, array.length);
    }

    public static void rotate(int[] array, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        if (array.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m4 = -distance % length;
        m4 = m4 < 0 ? m4 + length : m4;
        int newFirstIndex = m4 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Ints.reverse(array, fromIndex, newFirstIndex);
        Ints.reverse(array, newFirstIndex, toIndex);
        Ints.reverse(array, fromIndex, toIndex);
    }

    public static int[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof IntArrayAsList) {
            return ((IntArrayAsList)collection).toIntArray();
        }
        org.rascalmpl.java.lang.Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).intValue();
        }
        return array;
    }

    public static List<org.rascalmpl.java.lang.Integer> asList(int ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(backingArray);
    }

    @CheckForNull
    public static org.rascalmpl.java.lang.Integer tryParse(String string) {
        return Ints.tryParse(string, 10);
    }

    @CheckForNull
    public static org.rascalmpl.java.lang.Integer tryParse(String string, int radix) {
        Long result = Longs.tryParse(string, radix);
        if (result == null || result.longValue() != (long)result.intValue()) {
            return null;
        }
        return org.rascalmpl.java.lang.Integer.valueOf((int)result.intValue());
    }

    @GwtCompatible
    private static class IntArrayAsList
    extends AbstractList<org.rascalmpl.java.lang.Integer>
    implements RandomAccess,
    Serializable {
        final int[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        IntArrayAsList(int[] array) {
            this(array, 0, array.length);
        }

        IntArrayAsList(int[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        public int size() {
            return this.end - this.start;
        }

        public boolean isEmpty() {
            return false;
        }

        public org.rascalmpl.java.lang.Integer get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return org.rascalmpl.java.lang.Integer.valueOf((int)this.array[this.start + index]);
        }

        public Spliterator.OfInt spliterator() {
            return Spliterators.spliterator((int[])this.array, (int)this.start, (int)this.end, (int)0);
        }

        public boolean contains(@CheckForNull org.rascalmpl.java.lang.Object target) {
            return target instanceof org.rascalmpl.java.lang.Integer && Ints.indexOf(this.array, ((org.rascalmpl.java.lang.Integer)target).intValue(), this.start, this.end) != -1;
        }

        public int indexOf(@CheckForNull org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof org.rascalmpl.java.lang.Integer && (i = Ints.indexOf(this.array, ((org.rascalmpl.java.lang.Integer)target).intValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public int lastIndexOf(@CheckForNull org.rascalmpl.java.lang.Object target) {
            int i;
            if (target instanceof org.rascalmpl.java.lang.Integer && (i = Ints.lastIndexOf(this.array, ((org.rascalmpl.java.lang.Integer)target).intValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        public org.rascalmpl.java.lang.Integer set(int index, org.rascalmpl.java.lang.Integer element) {
            Preconditions.checkElementIndex(index, this.size());
            int oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).intValue();
            return org.rascalmpl.java.lang.Integer.valueOf((int)oldValue);
        }

        public List<org.rascalmpl.java.lang.Integer> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new IntArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        public boolean equals(@CheckForNull org.rascalmpl.java.lang.Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                IntArrayAsList that = (IntArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Ints.hashCode(this.array[i]);
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append((String)"org.rascalmpl., ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        int[] toIntArray() {
            return Arrays.copyOfRange((int[])this.array, (int)this.start, (int)this.end);
        }
    }

    private static final class LexicographicalComparator
    extends Enum<LexicographicalComparator>
    implements Comparator<int[]> {
        public static final /* enum */ LexicographicalComparator INSTANCE = new LexicographicalComparator((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ LexicographicalComparator[] $VALUES;

        public static LexicographicalComparator[] values() {
            return (LexicographicalComparator[])$VALUES.clone();
        }

        public static LexicographicalComparator valueOf(String name) {
            return (LexicographicalComparator)Enum.valueOf(LexicographicalComparator.class, (String)name);
        }

        private LexicographicalComparator() {
            super((String)string, n);
        }

        public int compare(int[] left, int[] right) {
            int minLength = Math.min((int)left.length, (int)right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Ints.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "org.rascalmpl.Ints.lexicographicalComparator()";
        }

        static {
            $VALUES = new LexicographicalComparator[]{INSTANCE};
        }
    }

    private static final class IntConverter
    extends Converter<String, org.rascalmpl.java.lang.Integer>
    implements Serializable {
        static final Converter<String, org.rascalmpl.java.lang.Integer> INSTANCE = new IntConverter();
        private static final long serialVersionUID = 1L;

        private IntConverter() {
        }

        @Override
        protected org.rascalmpl.java.lang.Integer doForward(String value) {
            return org.rascalmpl.java.lang.Integer.decode((String)value);
        }

        @Override
        protected String doBackward(org.rascalmpl.java.lang.Integer value) {
            return value.toString();
        }

        public String toString() {
            return "org.rascalmpl.Ints.stringConverter()";
        }

        private org.rascalmpl.java.lang.Object readResolve() {
            return INSTANCE;
        }
    }
}

