/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.InvocationHandler;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.lang.reflect.Proxy;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
public abstract class AbstractInvocationHandler
extends Object
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];

    @CheckForNull
    public final Object invoke(Object proxy, Method method, @CheckForNull @Nullable Object[] args) throws Throwable {
        if (args == null) {
            args = NO_ARGS;
        }
        if (args.length == 0 && method.getName().equals((Object)"org.rascalmpl.hashCode")) {
            return Integer.valueOf((int)this.hashCode());
        }
        if (args.length == 1 && method.getName().equals((Object)"org.rascalmpl.equals") && method.getParameterTypes()[0] == Object.class) {
            Object arg = args[0];
            if (arg == null) {
                return Boolean.valueOf((boolean)false);
            }
            if (proxy == arg) {
                return Boolean.valueOf((boolean)true);
            }
            return Boolean.valueOf((AbstractInvocationHandler.isProxyOfSameInterfaces(arg, proxy.getClass()) && this.equals((Object)Proxy.getInvocationHandler((Object)arg)) ? 1 : 0) != 0);
        }
        if (args.length == 0 && method.getName().equals((Object)"org.rascalmpl.toString")) {
            return this.toString();
        }
        return this.handleInvocation(proxy, method, args);
    }

    @CheckForNull
    protected abstract Object handleInvocation(Object var1, Method var2, @Nullable Object[] var3) throws Throwable;

    public boolean equals(@CheckForNull Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    private static boolean isProxyOfSameInterfaces(Object arg, Class<?> proxyClass) {
        return proxyClass.isInstance(arg) || Proxy.isProxyClass((Class)arg.getClass()) && Arrays.equals((Object[])arg.getClass().getInterfaces(), (Object[])proxyClass.getInterfaces());
    }
}

