/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ForwardingMap;
import org.rascalmpl.com.google.common.collect.ForwardingMapEntry;
import org.rascalmpl.com.google.common.collect.ForwardingSet;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.reflect.ParametricNullness;
import org.rascalmpl.com.google.common.reflect.TypeToInstanceMap;
import org.rascalmpl.com.google.common.reflect.TypeToken;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.DoNotCall;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.NonNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
public final class MutableTypeToInstanceMap<B extends @Nullable org.rascalmpl.java.lang.Object>
extends ForwardingMap<TypeToken<? extends B>, B>
implements TypeToInstanceMap<B> {
    private final Map<TypeToken<? extends @NonNull B>, B> backingMap = Maps.newHashMap();

    @Override
    @CheckForNull
    public <T extends B> T getInstance(Class<T> type) {
        return this.trustedGet(TypeToken.of(type));
    }

    @Override
    @CheckForNull
    public <T extends B> T getInstance(TypeToken<T> type) {
        return this.trustedGet(type.rejectTypeVariables());
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public <T extends B> T putInstance(Class<@NonNull T> type, @ParametricNullness T value) {
        return this.trustedPut(TypeToken.of(type), value);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public <T extends B> T putInstance(TypeToken<@NonNull T> type, @ParametricNullness T value) {
        return this.trustedPut(type.rejectTypeVariables(), value);
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public B put(TypeToken<? extends @NonNull B> key, @ParametricNullness B value) {
        throw new UnsupportedOperationException((String)"org.rascalmpl.Please use putInstance() instead.");
    }

    @Override
    @Deprecated
    @DoNotCall(value="org.rascalmpl.Always throws UnsupportedOperationException")
    public void putAll(Map<? extends TypeToken<? extends @NonNull B>, ? extends B> map) {
        throw new UnsupportedOperationException((String)"org.rascalmpl.Please use putInstance() instead.");
    }

    @Override
    public Set<// Could not load outer class - annotation placement on inner may be incorrect
    Map.Entry<TypeToken<? extends @NonNull B>, B>> entrySet() {
        return UnmodifiableEntry.transformEntries(super.entrySet());
    }

    @Override
    protected Map<TypeToken<? extends @NonNull B>, B> delegate() {
        return this.backingMap;
    }

    @CheckForNull
    private <T extends B> T trustedPut(TypeToken<@NonNull T> type, @ParametricNullness T value) {
        return (T)this.backingMap.put(type, value);
    }

    @CheckForNull
    private <T extends B> T trustedGet(TypeToken<T> type) {
        return (T)this.backingMap.get(type);
    }

    private static final class UnmodifiableEntry<K extends org.rascalmpl.java.lang.Object, V extends @Nullable org.rascalmpl.java.lang.Object>
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Set<Map.Entry<K, V>> transformEntries(final Set<Map.Entry<K, V>> entries) {
            return new ForwardingSet<Map.Entry<K, V>>(){

                @Override
                protected Set<Map.Entry<K, V>> delegate() {
                    return entries;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return UnmodifiableEntry.transformEntries(super.iterator());
                }

                @Override
                public org.rascalmpl.java.lang.Object[] toArray() {
                    org.rascalmpl.java.lang.Object[] result = this.standardToArray();
                    return result;
                }

                @Override
                public <T extends org.rascalmpl.java.lang.Object> T[] toArray(T[] array) {
                    return this.standardToArray((org.rascalmpl.java.lang.Object[])array);
                }
            };
        }

        /*
         * Exception decompiling
         */
        private static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Iterator<Map.Entry<K, V>> transformEntries(Iterator<Map.Entry<K, V>> entries) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private UnmodifiableEntry(Map.Entry<K, V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V value) {
            throw new UnsupportedOperationException();
        }
    }
}

