/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.reflect.InvocationHandler;
import org.rascalmpl.java.lang.reflect.Proxy;

@ElementTypesAreNonnullByDefault
public final class Reflection
extends Object {
    public static String getPackageName(Class<?> clazz) {
        return Reflection.getPackageName(clazz.getName());
    }

    public static String getPackageName(String classFullName) {
        int lastDot = classFullName.lastIndexOf(46);
        return lastDot < 0 ? "org.rascalmpl." : classFullName.substring(0, lastDot);
    }

    public static void initialize(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            try {
                Class.forName((String)clazz.getName(), (boolean)true, (ClassLoader)clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static <T extends Object> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        Preconditions.checkNotNull(handler);
        Preconditions.checkArgument(interfaceType.isInterface(), (String)"org.rascalmpl.%s is not an interface", interfaceType);
        Object object = Proxy.newProxyInstance((ClassLoader)interfaceType.getClassLoader(), (Class[])new Class[]{interfaceType}, (InvocationHandler)handler);
        return (T)interfaceType.cast(object);
    }

    private Reflection() {
    }
}

