/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.reflect;

import org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.com.google.common.reflect.ElementTypesAreNonnullByDefault;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.reflect.GenericArrayType;
import org.rascalmpl.java.lang.reflect.ParameterizedType;
import org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.java.lang.reflect.TypeVariable;
import org.rascalmpl.java.lang.reflect.WildcardType;
import org.rascalmpl.java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class TypeVisitor
extends Object {
    private final Set<Type> visited = Sets.newHashSet();

    TypeVisitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visit(Type ... types) {
        for (Type type : types) {
            if (type == null || !this.visited.add((Object)type)) continue;
            boolean succeeded = false;
            try {
                if (type instanceof TypeVariable) {
                    this.visitTypeVariable((TypeVariable)type);
                } else if (type instanceof WildcardType) {
                    this.visitWildcardType((WildcardType)type);
                } else if (type instanceof ParameterizedType) {
                    this.visitParameterizedType((ParameterizedType)type);
                } else if (type instanceof Class) {
                    this.visitClass((Class)type);
                } else if (type instanceof GenericArrayType) {
                    this.visitGenericArrayType((GenericArrayType)type);
                } else {
                    throw new AssertionError((Object)new StringBuilder().append((String)"org.rascalmpl.Unknown type: ").append((Object)type).toString());
                }
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.visited.remove((Object)type);
                }
            }
        }
    }

    void visitClass(Class<?> t2) {
    }

    void visitGenericArrayType(GenericArrayType t2) {
    }

    void visitParameterizedType(ParameterizedType t2) {
    }

    void visitTypeVariable(TypeVariable<?> t2) {
    }

    void visitWildcardType(WildcardType t2) {
    }
}

