/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.ListenerCallQueue;
import org.rascalmpl.com.google.common.util.concurrent.Monitor;
import org.rascalmpl.com.google.common.util.concurrent.Platform;
import org.rascalmpl.com.google.common.util.concurrent.Service;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.ForOverride;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractService
extends org.rascalmpl.java.lang.Object
implements Service {
    private static final ListenerCallQueue.Event<Service.Listener> STARTING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

        @Override
        public void call(Service.Listener listener) {
            listener.starting();
        }

        public String toString() {
            return "org.rascalmpl.starting()";
        }
    };
    private static final ListenerCallQueue.Event<Service.Listener> RUNNING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

        @Override
        public void call(Service.Listener listener) {
            listener.running();
        }

        public String toString() {
            return "org.rascalmpl.running()";
        }
    };
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_STARTING_EVENT = AbstractService.stoppingEvent(Service.State.STARTING);
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_RUNNING_EVENT = AbstractService.stoppingEvent(Service.State.RUNNING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_NEW_EVENT = AbstractService.terminatedEvent(Service.State.NEW);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STARTING_EVENT = AbstractService.terminatedEvent(Service.State.STARTING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_RUNNING_EVENT = AbstractService.terminatedEvent(Service.State.RUNNING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STOPPING_EVENT = AbstractService.terminatedEvent(Service.State.STOPPING);
    private final Monitor monitor = new Monitor();
    private final Monitor.Guard isStartable = new IsStartableGuard();
    private final Monitor.Guard isStoppable = new IsStoppableGuard();
    private final Monitor.Guard hasReachedRunning = new HasReachedRunningGuard();
    private final Monitor.Guard isStopped = new IsStoppedGuard();
    private final ListenerCallQueue<Service.Listener> listeners = new ListenerCallQueue();
    private volatile StateSnapshot snapshot = new StateSnapshot(Service.State.NEW);

    private static ListenerCallQueue.Event<Service.Listener> terminatedEvent(final Service.State from) {
        return new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.terminated(from);
            }

            public String toString() {
                return new StringBuilder().append((String)"org.rascalmpl.terminated({from = ").append((org.rascalmpl.java.lang.Object)from).append((String)"org.rascalmpl.})").toString();
            }
        };
    }

    private static ListenerCallQueue.Event<Service.Listener> stoppingEvent(final Service.State from) {
        return new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.stopping(from);
            }

            public String toString() {
                return new StringBuilder().append((String)"org.rascalmpl.stopping({from = ").append((org.rascalmpl.java.lang.Object)from).append((String)"org.rascalmpl.})").toString();
            }
        };
    }

    protected AbstractService() {
    }

    @ForOverride
    protected abstract void doStart();

    @ForOverride
    protected abstract void doStop();

    @ForOverride
    protected void doCancelStart() {
    }

    @Override
    @CanIgnoreReturnValue
    public final Service startAsync() {
        if (this.monitor.enterIf(this.isStartable)) {
            try {
                this.snapshot = new StateSnapshot(Service.State.STARTING);
                this.enqueueStartingEvent();
                this.doStart();
            }
            catch (Throwable startupFailure) {
                Platform.restoreInterruptIfIsInterruptedException(startupFailure);
                this.notifyFailed(startupFailure);
            }
            finally {
                this.monitor.leave();
                this.dispatchListenerEvents();
            }
        } else {
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Service ").append((org.rascalmpl.java.lang.Object)this).append((String)"org.rascalmpl. has already been started").toString());
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @CanIgnoreReturnValue
    public final Service stopAsync() {
        if (!this.monitor.enterIf(this.isStoppable)) return this;
        try {
            Service.State previous = this.state();
            switch (previous) {
                case NEW: {
                    this.snapshot = new StateSnapshot(Service.State.TERMINATED);
                    this.enqueueTerminatedEvent(Service.State.NEW);
                    return this;
                }
                case STARTING: {
                    this.snapshot = new StateSnapshot(Service.State.STARTING, true, null);
                    this.enqueueStoppingEvent(Service.State.STARTING);
                    this.doCancelStart();
                    return this;
                }
                case RUNNING: {
                    this.snapshot = new StateSnapshot(Service.State.STOPPING);
                    this.enqueueStoppingEvent(Service.State.RUNNING);
                    this.doStop();
                    return this;
                }
                case STOPPING: 
                case TERMINATED: 
                case FAILED: {
                    throw new AssertionError((org.rascalmpl.java.lang.Object)new StringBuilder().append((String)"org.rascalmpl.isStoppable is incorrectly implemented, saw: ").append((org.rascalmpl.java.lang.Object)previous).toString());
                }
            }
            return this;
        }
        catch (Throwable shutdownFailure) {
            Platform.restoreInterruptIfIsInterruptedException(shutdownFailure);
            this.notifyFailed(shutdownFailure);
            return this;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    @Override
    public final void awaitRunning() {
        this.monitor.enterWhenUninterruptibly(this.hasReachedRunning);
        try {
            this.checkCurrentState(Service.State.RUNNING);
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    public final void awaitRunning(Duration timeout) throws TimeoutException {
        Service.super.awaitRunning(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        if (this.monitor.enterWhenUninterruptibly(this.hasReachedRunning, timeout, unit)) {
            try {
                this.checkCurrentState(Service.State.RUNNING);
            }
            finally {
                this.monitor.leave();
            }
        } else {
            throw new TimeoutException(new StringBuilder().append((String)"org.rascalmpl.Timed out waiting for ").append((org.rascalmpl.java.lang.Object)this).append((String)"org.rascalmpl. to reach the RUNNING state.").toString());
        }
    }

    @Override
    public final void awaitTerminated() {
        this.monitor.enterWhenUninterruptibly(this.isStopped);
        try {
            this.checkCurrentState(Service.State.TERMINATED);
        }
        finally {
            this.monitor.leave();
        }
    }

    @Override
    public final void awaitTerminated(Duration timeout) throws TimeoutException {
        Service.super.awaitTerminated(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        if (this.monitor.enterWhenUninterruptibly(this.isStopped, timeout, unit)) {
            try {
                this.checkCurrentState(Service.State.TERMINATED);
            }
            finally {
                this.monitor.leave();
            }
        } else {
            throw new TimeoutException(new StringBuilder().append((String)"org.rascalmpl.Timed out waiting for ").append((org.rascalmpl.java.lang.Object)this).append((String)"org.rascalmpl. to reach a terminal state. Current state: ").append((org.rascalmpl.java.lang.Object)this.state()).toString());
        }
    }

    @GuardedBy(value="org.rascalmpl.monitor")
    private void checkCurrentState(Service.State expected) {
        Service.State actual = this.state();
        if (actual != expected) {
            if (actual == Service.State.FAILED) {
                throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Expected the service ").append((org.rascalmpl.java.lang.Object)this).append((String)"org.rascalmpl. to be ").append((org.rascalmpl.java.lang.Object)expected).append((String)"org.rascalmpl., but the service has FAILED").toString(), this.failureCause());
            }
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Expected the service ").append((org.rascalmpl.java.lang.Object)this).append((String)"org.rascalmpl. to be ").append((org.rascalmpl.java.lang.Object)expected).append((String)"org.rascalmpl., but was ").append((org.rascalmpl.java.lang.Object)actual).toString());
        }
    }

    protected final void notifyStarted() {
        this.monitor.enter();
        try {
            if (this.snapshot.state != Service.State.STARTING) {
                IllegalStateException failure = new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot notifyStarted() when the service is ").append((org.rascalmpl.java.lang.Object)this.snapshot.state).toString());
                this.notifyFailed((Throwable)((Object)failure));
                throw failure;
            }
            if (this.snapshot.shutdownWhenStartupFinishes) {
                this.snapshot = new StateSnapshot(Service.State.STOPPING);
                this.doStop();
            } else {
                this.snapshot = new StateSnapshot(Service.State.RUNNING);
                this.enqueueRunningEvent();
            }
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void notifyStopped() {
        this.monitor.enter();
        try {
            Service.State previous = this.state();
            switch (previous) {
                case NEW: 
                case TERMINATED: 
                case FAILED: {
                    throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Cannot notifyStopped() when the service is ").append((org.rascalmpl.java.lang.Object)previous).toString());
                }
                case STARTING: 
                case RUNNING: 
                case STOPPING: {
                    this.snapshot = new StateSnapshot(Service.State.TERMINATED);
                    this.enqueueTerminatedEvent(previous);
                    return;
                }
            }
            return;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void notifyFailed(Throwable cause) {
        Preconditions.checkNotNull(cause);
        this.monitor.enter();
        try {
            Service.State previous = this.state();
            switch (previous) {
                case NEW: 
                case TERMINATED: {
                    throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Failed while in state:").append((org.rascalmpl.java.lang.Object)previous).toString(), cause);
                }
                case STARTING: 
                case RUNNING: 
                case STOPPING: {
                    this.snapshot = new StateSnapshot(Service.State.FAILED, false, cause);
                    this.enqueueFailedEvent(previous, cause);
                    return;
                }
            }
            return;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.state() == Service.State.RUNNING;
    }

    @Override
    public final Service.State state() {
        return this.snapshot.externalState();
    }

    @Override
    public final Throwable failureCause() {
        return this.snapshot.failureCause();
    }

    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        this.listeners.addListener(listener, executor);
    }

    public String toString() {
        return new StringBuilder().append(this.getClass().getSimpleName()).append((String)"org.rascalmpl. [").append((org.rascalmpl.java.lang.Object)this.state()).append((String)"org.rascalmpl.]").toString();
    }

    private void dispatchListenerEvents() {
        if (!this.monitor.isOccupiedByCurrentThread()) {
            this.listeners.dispatch();
        }
    }

    private void enqueueStartingEvent() {
        this.listeners.enqueue(STARTING_EVENT);
    }

    private void enqueueRunningEvent() {
        this.listeners.enqueue(RUNNING_EVENT);
    }

    private void enqueueStoppingEvent(Service.State from) {
        if (from == Service.State.STARTING) {
            this.listeners.enqueue(STOPPING_FROM_STARTING_EVENT);
        } else if (from == Service.State.RUNNING) {
            this.listeners.enqueue(STOPPING_FROM_RUNNING_EVENT);
        } else {
            throw new AssertionError();
        }
    }

    private void enqueueTerminatedEvent(Service.State from) {
        switch (from) {
            case NEW: {
                this.listeners.enqueue(TERMINATED_FROM_NEW_EVENT);
                break;
            }
            case STARTING: {
                this.listeners.enqueue(TERMINATED_FROM_STARTING_EVENT);
                break;
            }
            case RUNNING: {
                this.listeners.enqueue(TERMINATED_FROM_RUNNING_EVENT);
                break;
            }
            case STOPPING: {
                this.listeners.enqueue(TERMINATED_FROM_STOPPING_EVENT);
                break;
            }
            case TERMINATED: 
            case FAILED: {
                throw new AssertionError();
            }
        }
    }

    private void enqueueFailedEvent(final Service.State from, final Throwable cause) {
        this.listeners.enqueue(new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.failed(from, cause);
            }

            public String toString() {
                return new StringBuilder().append((String)"org.rascalmpl.failed({from = ").append((org.rascalmpl.java.lang.Object)from).append((String)"org.rascalmpl., cause = ").append((org.rascalmpl.java.lang.Object)cause).append((String)"org.rascalmpl.})").toString();
            }
        });
    }

    private static final class StateSnapshot
    extends org.rascalmpl.java.lang.Object {
        final Service.State state;
        final boolean shutdownWhenStartupFinishes;
        @CheckForNull
        final Throwable failure;

        StateSnapshot(Service.State internalState) {
            this(internalState, false, null);
        }

        StateSnapshot(Service.State internalState, boolean shutdownWhenStartupFinishes, @CheckForNull Throwable failure) {
            Preconditions.checkArgument(!shutdownWhenStartupFinishes || internalState == Service.State.STARTING, (String)"org.rascalmpl.shutdownWhenStartupFinishes can only be set if state is STARTING. Got %s instead.", (org.rascalmpl.java.lang.Object)internalState);
            Preconditions.checkArgument(failure != null == (internalState == Service.State.FAILED), (String)"org.rascalmpl.A failure cause should be set if and only if the state is failed.  Got %s and %s instead.", (org.rascalmpl.java.lang.Object)internalState, (org.rascalmpl.java.lang.Object)failure);
            this.state = internalState;
            this.shutdownWhenStartupFinishes = shutdownWhenStartupFinishes;
            this.failure = failure;
        }

        Service.State externalState() {
            if (this.shutdownWhenStartupFinishes && this.state == Service.State.STARTING) {
                return Service.State.STOPPING;
            }
            return this.state;
        }

        Throwable failureCause() {
            Preconditions.checkState(this.state == Service.State.FAILED, (String)"org.rascalmpl.failureCause() is only valid if the service has failed, service is %s", (org.rascalmpl.java.lang.Object)this.state);
            return (Throwable)Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.failure);
        }
    }

    private final class IsStoppedGuard
    extends Monitor.Guard {
        IsStoppedGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.TERMINATED) >= 0;
        }
    }

    private final class HasReachedRunningGuard
    extends Monitor.Guard {
        HasReachedRunningGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.RUNNING) >= 0;
        }
    }

    private final class IsStoppableGuard
    extends Monitor.Guard {
        IsStoppableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.RUNNING) <= 0;
        }
    }

    private final class IsStartableGuard
    extends Monitor.Guard {
        IsStartableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state() == Service.State.NEW;
        }
    }
}

