/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.util.concurrent.AsyncFunction;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.FluentFuture;
import org.rascalmpl.com.google.common.util.concurrent.Futures;
import org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.common.util.concurrent.Platform;
import org.rascalmpl.com.google.errorprone.annotations.ForOverride;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.java.lang.Error;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.concurrent.CancellationException;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractTransformFuture<I extends @Nullable org.rascalmpl.java.lang.Object, O extends @Nullable org.rascalmpl.java.lang.Object, F extends org.rascalmpl.java.lang.Object, T extends @Nullable org.rascalmpl.java.lang.Object>
extends FluentFuture.TrustedFuture<O>
implements Runnable {
    @CheckForNull
    @LazyInit
    ListenableFuture<? extends I> inputFuture;
    @CheckForNull
    @LazyInit
    F function;

    static <I extends org.rascalmpl.java.lang.Object, O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> create(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(executor);
        AsyncTransformFuture<? super I, ? extends O> output = new AsyncTransformFuture<I, O>(input, function);
        input.addListener(output, MoreExecutors.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    static <I extends org.rascalmpl.java.lang.Object, O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> create(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        TransformFuture<? super I, ? extends O> output = new TransformFuture<I, O>(input, function);
        input.addListener(output, MoreExecutors.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    AbstractTransformFuture(ListenableFuture<? extends I> inputFuture, F function) {
        this.inputFuture = Preconditions.checkNotNull(inputFuture);
        this.function = Preconditions.checkNotNull(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        T transformResult;
        I sourceResult;
        ListenableFuture<? extends I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        if (this.isCancelled() | localInputFuture == null | localFunction == null) {
            return;
        }
        this.inputFuture = null;
        if (localInputFuture.isCancelled()) {
            boolean unused = this.setFuture(localInputFuture);
            return;
        }
        try {
            sourceResult = Futures.getDone(localInputFuture);
        }
        catch (CancellationException e) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException e) {
            this.setException(e.getCause());
            return;
        }
        catch (Exception e) {
            this.setException((Throwable)((Object)e));
            return;
        }
        catch (Error e) {
            this.setException((Throwable)((Object)e));
            return;
        }
        try {
            transformResult = this.doTransform(localFunction, sourceResult);
        }
        catch (Throwable t2) {
            Platform.restoreInterruptIfIsInterruptedException(t2);
            this.setException(t2);
            return;
        }
        finally {
            this.function = null;
        }
        this.setResult(transformResult);
    }

    @ParametricNullness
    @ForOverride
    abstract T doTransform(F var1, @ParametricNullness I var2) throws Exception;

    @ForOverride
    abstract void setResult(@ParametricNullness T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        ListenableFuture<? extends I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        String superString = super.pendingToString();
        java.lang.String resultString = "org.rascalmpl.";
        if (localInputFuture != null) {
            resultString = new StringBuilder().append((String)"org.rascalmpl.inputFuture=[").append(localInputFuture).append((String)"org.rascalmpl.], ").toString();
        }
        if (localFunction != null) {
            return new StringBuilder().append((String)resultString).append((String)"org.rascalmpl.function=[").append(localFunction).append((String)"org.rascalmpl.]").toString();
        }
        if (superString != null) {
            return new StringBuilder().append((String)resultString).append(superString).toString();
        }
        return null;
    }

    private static final class TransformFuture<I extends @Nullable org.rascalmpl.java.lang.Object, O extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        TransformFuture(ListenableFuture<? extends I> inputFuture, Function<? super I, ? extends O> function) {
            super(inputFuture, function);
        }

        @Override
        @ParametricNullness
        O doTransform(Function<? super I, ? extends O> function, @ParametricNullness I input) {
            return function.apply(input);
        }

        @Override
        void setResult(@ParametricNullness O result) {
            this.set(result);
        }
    }

    private static final class AsyncTransformFuture<I extends @Nullable org.rascalmpl.java.lang.Object, O extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractTransformFuture<I, O, AsyncFunction<? super I, ? extends O>, ListenableFuture<? extends O>> {
        AsyncTransformFuture(ListenableFuture<? extends I> inputFuture, AsyncFunction<? super I, ? extends O> function) {
            super(inputFuture, function);
        }

        @Override
        ListenableFuture<? extends O> doTransform(AsyncFunction<? super I, ? extends O> function, @ParametricNullness I input) throws Exception {
            ListenableFuture<? extends O> outputFuture = function.apply(input);
            Preconditions.checkNotNull(outputFuture, (String)"org.rascalmpl.AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", function);
            return outputFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends O> result) {
            this.setFuture(result);
        }
    }
}

