/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.util.concurrent.AggregateFutureState;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.Futures;
import org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.errorprone.annotations.ForOverride;
import org.rascalmpl.com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Error;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AggregateFuture<InputT extends @Nullable org.rascalmpl.java.lang.Object, OutputT extends @Nullable org.rascalmpl.java.lang.Object>
extends AggregateFutureState<OutputT> {
    private static final LazyLogger logger = new LazyLogger((Class<?>)AggregateFuture.class);
    @CheckForNull
    @LazyInit
    private ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures;
    private final boolean allMustSucceed;
    private final boolean collectsValues;

    AggregateFuture(ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures, boolean allMustSucceed, boolean collectsValues) {
        super(futures.size());
        this.futures = Preconditions.checkNotNull(futures);
        this.allMustSucceed = allMustSucceed;
        this.collectsValues = collectsValues;
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        ImmutableCollection<ListenableFuture<InputT>> localFutures = this.futures;
        this.releaseResources(ReleaseResourcesReason.OUTPUT_FUTURE_DONE);
        if (this.isCancelled() & localFutures != null) {
            boolean wasInterrupted = this.wasInterrupted();
            Iterator iterator = localFutures.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                future.cancel(wasInterrupted);
            }
        }
    }

    @Override
    @CheckForNull
    protected final String pendingToString() {
        ImmutableCollection<? extends ListenableFuture<? extends InputT>> localFutures = this.futures;
        if (localFutures != null) {
            return new StringBuilder().append((String)"org.rascalmpl.futures=").append(localFutures).toString();
        }
        return super.pendingToString();
    }

    /*
     * Exception decompiling
     */
    final void init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleException(Throwable throwable) {
        boolean firstTimeSeeingThisException;
        boolean completedWithFailure;
        Preconditions.checkNotNull(throwable);
        if (this.allMustSucceed && !(completedWithFailure = this.setException(throwable)) && (firstTimeSeeingThisException = AggregateFuture.addCausalChain(this.getOrInitSeenExceptions(), throwable))) {
            AggregateFuture.log(throwable);
            return;
        }
        if (throwable instanceof Error) {
            AggregateFuture.log(throwable);
        }
    }

    private static void log(Throwable throwable) {
        java.lang.String message = throwable instanceof Error ? "org.rascalmpl.Input Future failed with Error" : "org.rascalmpl.Got more than one input Future failure. Logging failures after the first";
        logger.get().log(Level.SEVERE, (String)message, throwable);
    }

    @Override
    final void addInitialException(Set<Throwable> seen) {
        Preconditions.checkNotNull(seen);
        if (!this.isCancelled()) {
            boolean bl = AggregateFuture.addCausalChain(seen, (Throwable)Objects.requireNonNull((org.rascalmpl.java.lang.Object)this.tryInternalFastPathGetFailure()));
        }
    }

    private void collectValueFromNonCancelledFuture(int index, Future<? extends InputT> future) {
        try {
            this.collectOneValue(index, Futures.getDone(future));
        }
        catch (ExecutionException e) {
            this.handleException(e.getCause());
        }
        catch (Throwable t2) {
            this.handleException(t2);
        }
    }

    private void decrementCountAndMaybeComplete(@CheckForNull ImmutableCollection<? extends Future<? extends InputT>> futuresIfNeedToCollectAtCompletion) {
        int newRemaining = this.decrementRemainingAndGet();
        Preconditions.checkState(newRemaining >= 0, (org.rascalmpl.java.lang.Object)"org.rascalmpl.Less than 0 remaining futures");
        if (newRemaining == 0) {
            this.processCompleted(futuresIfNeedToCollectAtCompletion);
        }
    }

    private void processCompleted(@CheckForNull ImmutableCollection<? extends Future<? extends InputT>> futuresIfNeedToCollectAtCompletion) {
        if (futuresIfNeedToCollectAtCompletion != null) {
            int i = 0;
            Iterator iterator = futuresIfNeedToCollectAtCompletion.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                if (!future.isCancelled()) {
                    this.collectValueFromNonCancelledFuture(i, future);
                }
                ++i;
            }
        }
        this.clearSeenExceptions();
        this.handleAllCompleted();
        this.releaseResources(ReleaseResourcesReason.ALL_INPUT_FUTURES_PROCESSED);
    }

    @ForOverride
    @OverridingMethodsMustInvokeSuper
    void releaseResources(ReleaseResourcesReason reason) {
        Preconditions.checkNotNull(reason);
        this.futures = null;
    }

    abstract void collectOneValue(int var1, @ParametricNullness InputT var2);

    abstract void handleAllCompleted();

    private static boolean addCausalChain(Set<Throwable> seen, Throwable param) {
        for (Throwable t2 = param; t2 != null; t2 = t2.getCause()) {
            boolean firstTimeSeen = seen.add((org.rascalmpl.java.lang.Object)t2);
            if (firstTimeSeen) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ void lambda$init$1(ImmutableCollection localFutures) {
        this.decrementCountAndMaybeComplete(localFutures);
    }

    private /* synthetic */ void lambda$init$0(ListenableFuture future, int index) {
        try {
            if (future.isCancelled()) {
                this.futures = null;
                this.cancel(false);
            } else {
                this.collectValueFromNonCancelledFuture(index, future);
            }
        }
        finally {
            this.decrementCountAndMaybeComplete(null);
        }
    }

    static final class ReleaseResourcesReason
    extends Enum<ReleaseResourcesReason> {
        public static final /* enum */ ReleaseResourcesReason OUTPUT_FUTURE_DONE = new ReleaseResourcesReason((String)"org.rascalmpl.OUTPUT_FUTURE_DONE", 0);
        public static final /* enum */ ReleaseResourcesReason ALL_INPUT_FUTURES_PROCESSED = new ReleaseResourcesReason((String)"org.rascalmpl.ALL_INPUT_FUTURES_PROCESSED", 1);
        private static final /* synthetic */ ReleaseResourcesReason[] $VALUES;

        public static ReleaseResourcesReason[] values() {
            return (ReleaseResourcesReason[])$VALUES.clone();
        }

        public static ReleaseResourcesReason valueOf(String name) {
            return (ReleaseResourcesReason)Enum.valueOf(ReleaseResourcesReason.class, (String)name);
        }

        private ReleaseResourcesReason() {
            super((String)string, n);
        }

        static {
            $VALUES = new ReleaseResourcesReason[]{OUTPUT_FUTURE_DONE, ALL_INPUT_FUTURES_PROCESSED};
        }
    }
}

