/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.ExecutionError;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.common.util.concurrent.Platform;
import org.rascalmpl.com.google.common.util.concurrent.TimeLimiter;
import org.rascalmpl.com.google.common.util.concurrent.UncheckedExecutionException;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Error;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class FakeTimeLimiter
extends Object
implements TimeLimiter {
    @Override
    @CanIgnoreReturnValue
    public <T extends Object> T newProxy(T target, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        return target;
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T extends Object> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return (T)callable.call();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException((Throwable)((java.lang.Object)e));
        }
        catch (Exception e) {
            Platform.restoreInterruptIfIsInterruptedException((Throwable)((java.lang.Object)e));
            throw new ExecutionException((Throwable)((java.lang.Object)e));
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T extends Object> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        return this.callWithTimeout(callable, timeoutDuration, timeoutUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw new UncheckedExecutionException((Throwable)((java.lang.Object)e));
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        this.runWithTimeout(runnable, timeoutDuration, timeoutUnit);
    }
}

