/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.collect.ForwardingObject;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.CheckReturnValue;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.ExecutorService;
import org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public abstract class ForwardingExecutorService
extends ForwardingObject
implements ExecutorService {
    protected ForwardingExecutorService() {
    }

    protected abstract ExecutorService delegate();

    @CheckReturnValue
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate().awaitTermination(timeout, unit);
    }

    public <T extends Object> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate().invokeAll(tasks);
    }

    public <T extends Object> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate().invokeAll(tasks, timeout, unit);
    }

    public <T extends Object> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate().invokeAny(tasks);
    }

    public <T extends Object> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate().invokeAny(tasks, timeout, unit);
    }

    public boolean isShutdown() {
        return this.delegate().isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate().isTerminated();
    }

    public void shutdown() {
        this.delegate().shutdown();
    }

    @CanIgnoreReturnValue
    public List<Runnable> shutdownNow() {
        return this.delegate().shutdownNow();
    }

    public void execute(Runnable command) {
        this.delegate().execute(command);
    }

    public <T extends Object> Future<T> submit(Callable<T> task) {
        return this.delegate().submit(task);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate().submit(task);
    }

    public <T extends Object> Future<T> submit(Runnable task, @ParametricNullness T result) {
        return this.delegate().submit(task, result);
    }
}

