/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ForwardingObject;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingFuture<V extends @Nullable Object>
extends ForwardingObject
implements Future<V> {
    protected ForwardingFuture() {
    }

    protected abstract Future<? extends V> delegate();

    @CanIgnoreReturnValue
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate().cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate().isCancelled();
    }

    public boolean isDone() {
        return this.delegate().isDone();
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.delegate().get();
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.delegate().get(timeout, unit);
    }

    public static abstract class SimpleForwardingFuture<V extends @Nullable Object>
    extends ForwardingFuture<V> {
        private final Future<V> delegate;

        protected SimpleForwardingFuture(Future<V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final Future<V> delegate() {
            return this.delegate;
        }
    }
}

