/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.util.concurrent.AbstractCatchingFuture;
import org.rascalmpl.com.google.common.util.concurrent.AbstractFuture;
import org.rascalmpl.com.google.common.util.concurrent.AbstractTransformFuture;
import org.rascalmpl.com.google.common.util.concurrent.AsyncCallable;
import org.rascalmpl.com.google.common.util.concurrent.AsyncFunction;
import org.rascalmpl.com.google.common.util.concurrent.CollectionFuture;
import org.rascalmpl.com.google.common.util.concurrent.CombinedFuture;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.ExecutionError;
import org.rascalmpl.com.google.common.util.concurrent.FutureCallback;
import org.rascalmpl.com.google.common.util.concurrent.FuturesGetChecked;
import org.rascalmpl.com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import org.rascalmpl.com.google.common.util.concurrent.ImmediateFuture;
import org.rascalmpl.com.google.common.util.concurrent.Internal;
import org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.common.util.concurrent.Partially;
import org.rascalmpl.com.google.common.util.concurrent.TimeoutFuture;
import org.rascalmpl.com.google.common.util.concurrent.TrustedListenableFutureTask;
import org.rascalmpl.com.google.common.util.concurrent.UncheckedExecutionException;
import org.rascalmpl.com.google.common.util.concurrent.Uninterruptibles;
import org.rascalmpl.com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import org.rascalmpl.com.google.common.util.concurrent.internal.InternalFutures;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Error;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.Void;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.java.util.concurrent.ScheduledExecutorService;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.java.util.concurrent.atomic.AtomicInteger;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Futures
extends GwtFuturesCatchingSpecialization {
    private Futures() {
    }

    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<V> immediateFuture(@ParametricNullness V value) {
        if (value == null) {
            ListenableFuture<?> typedNull = ImmediateFuture.NULL;
            return typedNull;
        }
        return new ImmediateFuture<V>(value);
    }

    public static ListenableFuture<@Nullable Void> immediateVoidFuture() {
        return ImmediateFuture.NULL;
    }

    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable);
    }

    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<V> immediateCancelledFuture() {
        ImmediateFuture.ImmediateCancelledFuture<org.rascalmpl.java.lang.Object> instance = ImmediateFuture.ImmediateCancelledFuture.INSTANCE;
        if (instance != null) {
            return instance;
        }
        return new ImmediateFuture.ImmediateCancelledFuture();
    }

    public static <O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> submit(Callable<O> callable, Executor executor) {
        TrustedListenableFutureTask<O> task = TrustedListenableFutureTask.create(callable);
        executor.execute(task);
        return task;
    }

    public static ListenableFuture<@Nullable Void> submit(Runnable runnable, Executor executor) {
        TrustedListenableFutureTask<@Nullable Object> task = TrustedListenableFutureTask.create(runnable, null);
        executor.execute(task);
        return task;
    }

    public static <O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> submitAsync(AsyncCallable<O> callable, Executor executor) {
        TrustedListenableFutureTask<O> task = TrustedListenableFutureTask.create(callable);
        executor.execute(task);
        return task;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> scheduleAsync(AsyncCallable<O> callable, Duration delay, ScheduledExecutorService executorService) {
        return Futures.scheduleAsync(callable, Internal.toNanosSaturated(delay), TimeUnit.NANOSECONDS, executorService);
    }

    /*
     * Exception decompiling
     */
    @J2ktIncompatible
    @GwtIncompatible
    public static <O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> scheduleAsync(AsyncCallable<O> callable, long delay, TimeUnit timeUnit, ScheduledExecutorService executorService) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="org.rascalmpl.AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V extends org.rascalmpl.java.lang.Object, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        return AbstractCatchingFuture.create(input, exceptionType, fallback, executor);
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="org.rascalmpl.AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V extends org.rascalmpl.java.lang.Object, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        return AbstractCatchingFuture.create(input, exceptionType, fallback, executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<V> withTimeout(ListenableFuture<V> delegate, Duration time, ScheduledExecutorService scheduledExecutor) {
        return Futures.withTimeout(delegate, Internal.toNanosSaturated(time), TimeUnit.NANOSECONDS, scheduledExecutor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<V> withTimeout(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        if (delegate.isDone()) {
            return delegate;
        }
        return TimeoutFuture.create(delegate, time, unit, scheduledExecutor);
    }

    public static <I extends org.rascalmpl.java.lang.Object, O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(input, function, executor);
    }

    public static <I extends org.rascalmpl.java.lang.Object, O extends org.rascalmpl.java.lang.Object> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(input, function, executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <I extends org.rascalmpl.java.lang.Object, O extends org.rascalmpl.java.lang.Object> Future<O> lazyTransform(final Future<I> input, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            public boolean cancel(boolean mayInterruptIfRunning) {
                return input.cancel(mayInterruptIfRunning);
            }

            public boolean isCancelled() {
                return input.isCancelled();
            }

            public boolean isDone() {
                return input.isDone();
            }

            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(input.get());
            }

            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(input.get(timeout, unit));
            }

            private O applyTransformation(I input2) throws ExecutionException {
                try {
                    return function.apply(input2);
                }
                catch (Throwable t2) {
                    throw new ExecutionException(t2);
                }
            }
        };
    }

    @SafeVarargs
    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... futures) {
        CollectionFuture.ListFuture nullable;
        CollectionFuture.ListFuture nonNull = nullable = new CollectionFuture.ListFuture(ImmutableList.copyOf((org.rascalmpl.java.lang.Object[])futures), true);
        return nonNull;
    }

    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        CollectionFuture.ListFuture nullable;
        CollectionFuture.ListFuture nonNull = nullable = new CollectionFuture.ListFuture(ImmutableList.copyOf(futures), true);
        return nonNull;
    }

    @SafeVarargs
    public static <V extends org.rascalmpl.java.lang.Object> FutureCombiner<V> whenAllComplete(ListenableFuture<? extends V> ... futures) {
        return new FutureCombiner(false, ImmutableList.copyOf((org.rascalmpl.java.lang.Object[])futures));
    }

    public static <V extends org.rascalmpl.java.lang.Object> FutureCombiner<V> whenAllComplete(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new FutureCombiner(false, ImmutableList.copyOf(futures));
    }

    @SafeVarargs
    public static <V extends org.rascalmpl.java.lang.Object> FutureCombiner<V> whenAllSucceed(ListenableFuture<? extends V> ... futures) {
        return new FutureCombiner(true, ImmutableList.copyOf((org.rascalmpl.java.lang.Object[])futures));
    }

    public static <V extends org.rascalmpl.java.lang.Object> FutureCombiner<V> whenAllSucceed(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new FutureCombiner(true, ImmutableList.copyOf(futures));
    }

    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> future) {
        if (future.isDone()) {
            return future;
        }
        NonCancellationPropagatingFuture<V> output = new NonCancellationPropagatingFuture<V>(future);
        future.addListener(output, MoreExecutors.directExecutor());
        return output;
    }

    @SafeVarargs
    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<List<@Nullable V>> successfulAsList(ListenableFuture<? extends V> ... futures) {
        return new CollectionFuture.ListFuture(ImmutableList.copyOf((org.rascalmpl.java.lang.Object[])futures), false);
    }

    public static <V extends org.rascalmpl.java.lang.Object> ListenableFuture<List<@Nullable V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new CollectionFuture.ListFuture(ImmutableList.copyOf(futures), false);
    }

    /*
     * Exception decompiling
     */
    public static <T extends org.rascalmpl.java.lang.Object> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> futures) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T extends org.rascalmpl.java.lang.Object> ListenableFuture<? extends T>[] gwtCompatibleToArray(Iterable<? extends ListenableFuture<? extends T>> futures) {
        Object collection = futures instanceof Collection ? (Collection)futures : ImmutableList.copyOf(futures);
        return (ListenableFuture[])collection.toArray((org.rascalmpl.java.lang.Object[])new ListenableFuture[0]);
    }

    public static <V extends org.rascalmpl.java.lang.Object> void addCallback(ListenableFuture<V> future, FutureCallback<? super V> callback, Executor executor) {
        Preconditions.checkNotNull(callback);
        future.addListener(new CallbackListener<V>(future, callback), executor);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <V extends org.rascalmpl.java.lang.Object> V getDone(Future<V> future) throws ExecutionException {
        Preconditions.checkState(future.isDone(), (String)"org.rascalmpl.Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V extends org.rascalmpl.java.lang.Object, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass) throws X {
        return FuturesGetChecked.getChecked(future, exceptionClass);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V extends org.rascalmpl.java.lang.Object, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, Duration timeout) throws X {
        return Futures.getChecked(future, exceptionClass, Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static <V extends org.rascalmpl.java.lang.Object, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, long timeout, TimeUnit unit) throws X {
        return FuturesGetChecked.getChecked(future, exceptionClass, timeout, unit);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <V extends org.rascalmpl.java.lang.Object> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException e) {
            Futures.wrapAndThrowUnchecked(e.getCause());
            throw new AssertionError();
        }
    }

    private static void wrapAndThrowUnchecked(Throwable cause) {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)((Object)cause));
        }
        throw new UncheckedExecutionException(cause);
    }

    private static /* synthetic */ void lambda$inCompletionOrder$1(InCompletionOrderState state, ImmutableList delegates, int localI) {
        state.recordInputCompletion(delegates, localI);
    }

    private static /* synthetic */ void lambda$scheduleAsync$0(Future scheduled) {
        scheduled.cancel(false);
    }

    private static final class CallbackListener<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Runnable {
        final Future<V> future;
        final FutureCallback<? super V> callback;

        CallbackListener(Future<V> future, FutureCallback<? super V> callback) {
            this.future = future;
            this.callback = callback;
        }

        public void run() {
            V value;
            Throwable failure;
            if (this.future instanceof InternalFutureFailureAccess && (failure = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)this.future)) != null) {
                this.callback.onFailure(failure);
                return;
            }
            try {
                value = Futures.getDone(this.future);
            }
            catch (ExecutionException e) {
                this.callback.onFailure(e.getCause());
                return;
            }
            catch (Throwable e) {
                this.callback.onFailure(e);
                return;
            }
            this.callback.onSuccess(value);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.callback).toString();
        }
    }

    private static final class InCompletionOrderState<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        private boolean wasCancelled = false;
        private boolean shouldInterrupt = true;
        private final AtomicInteger incompleteOutputCount;
        private final @Nullable ListenableFuture<? extends T>[] inputFutures;
        private volatile int delegateIndex = 0;

        private InCompletionOrderState(ListenableFuture<? extends T>[] inputFutures) {
            this.inputFutures = inputFutures;
            this.incompleteOutputCount = new AtomicInteger(inputFutures.length);
        }

        private void recordOutputCancellation(boolean interruptIfRunning) {
            this.wasCancelled = true;
            if (!interruptIfRunning) {
                this.shouldInterrupt = false;
            }
            this.recordCompletion();
        }

        private void recordInputCompletion(ImmutableList<AbstractFuture<T>> delegates, int inputFutureIndex) {
            ListenableFuture inputFuture = (ListenableFuture)Objects.requireNonNull(this.inputFutures[inputFutureIndex]);
            this.inputFutures[inputFutureIndex] = null;
            for (int i = this.delegateIndex; i < delegates.size(); ++i) {
                if (!((AbstractFuture)delegates.get(i)).setFuture(inputFuture)) continue;
                this.recordCompletion();
                this.delegateIndex = i + 1;
                return;
            }
            this.delegateIndex = delegates.size();
        }

        private void recordCompletion() {
            if (this.incompleteOutputCount.decrementAndGet() == 0 && this.wasCancelled) {
                for (ListenableFuture<T> listenableFuture : this.inputFutures) {
                    if (listenableFuture == null) continue;
                    listenableFuture.cancel(this.shouldInterrupt);
                }
            }
        }
    }

    private static final class InCompletionOrderFuture<T extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractFuture<T> {
        @CheckForNull
        private InCompletionOrderState<T> state;

        private InCompletionOrderFuture(InCompletionOrderState<T> state) {
            this.state = state;
        }

        @Override
        public boolean cancel(boolean interruptIfRunning) {
            InCompletionOrderState<T> localState = this.state;
            if (super.cancel(interruptIfRunning)) {
                ((InCompletionOrderState)Objects.requireNonNull(localState)).recordOutputCancellation(interruptIfRunning);
                return true;
            }
            return false;
        }

        @Override
        protected void afterDone() {
            this.state = null;
        }

        @Override
        @CheckForNull
        protected String pendingToString() {
            InCompletionOrderState<T> localState = this.state;
            if (localState != null) {
                return new StringBuilder().append((String)"org.rascalmpl.inputCount=[").append(((InCompletionOrderState)localState).inputFutures.length).append((String)"org.rascalmpl.], remaining=[").append(((InCompletionOrderState)localState).incompleteOutputCount.get()).append((String)"org.rascalmpl.]").toString();
            }
            return null;
        }
    }

    private static final class NonCancellationPropagatingFuture<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends AbstractFuture.TrustedFuture<V>
    implements Runnable {
        @CheckForNull
        @LazyInit
        private ListenableFuture<V> delegate;

        NonCancellationPropagatingFuture(ListenableFuture<V> delegate) {
            this.delegate = delegate;
        }

        public void run() {
            ListenableFuture<V> localDelegate = this.delegate;
            if (localDelegate != null) {
                this.setFuture(localDelegate);
            }
        }

        @Override
        @CheckForNull
        protected String pendingToString() {
            ListenableFuture<V> localDelegate = this.delegate;
            if (localDelegate != null) {
                return new StringBuilder().append((String)"org.rascalmpl.delegate=[").append(localDelegate).append((String)"org.rascalmpl.]").toString();
            }
            return null;
        }

        @Override
        protected void afterDone() {
            this.delegate = null;
        }
    }

    @GwtCompatible
    public static final class FutureCombiner<V extends @Nullable org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object {
        private final boolean allMustSucceed;
        private final ImmutableList<ListenableFuture<? extends V>> futures;

        private FutureCombiner(boolean allMustSucceed, ImmutableList<ListenableFuture<? extends V>> futures) {
            this.allMustSucceed = allMustSucceed;
            this.futures = futures;
        }

        public <C extends org.rascalmpl.java.lang.Object> ListenableFuture<C> callAsync(AsyncCallable<C> combiner, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, combiner);
        }

        public <C extends org.rascalmpl.java.lang.Object> ListenableFuture<C> call(Callable<C> combiner, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, combiner);
        }

        public ListenableFuture<?> run(final Runnable combiner, Executor executor) {
            return this.call(new Callable<Void>(){

                @CheckForNull
                public Void call() throws Exception {
                    combiner.run();
                    return null;
                }
            }, executor);
        }
    }
}

