/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class LazyLogger
extends Object {
    private final String loggerName;
    private volatile @Nullable Logger logger;

    LazyLogger(Class<?> ownerOfLogger) {
        this.loggerName = ownerOfLogger.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logger get() {
        Logger local = this.logger;
        if (local != null) {
            return local;
        }
        LazyLogger lazyLogger = this;
        synchronized (lazyLogger) {
            local = this.logger;
            if (local != null) {
                return local;
            }
            this.logger = Logger.getLogger((String)this.loggerName);
            return this.logger;
        }
    }
}

