/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.ExecutionList;
import org.rascalmpl.com.google.common.util.concurrent.ListenableFuture;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.java.util.concurrent.FutureTask;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public class ListenableFutureTask<V extends @Nullable Object>
extends FutureTask<V>
implements ListenableFuture<V> {
    private final ExecutionList executionList = new ExecutionList();

    public static <V extends Object> ListenableFutureTask<V> create(Callable<V> callable) {
        return new ListenableFutureTask<V>(callable);
    }

    public static <V extends Object> ListenableFutureTask<V> create(Runnable runnable, @ParametricNullness V result) {
        return new ListenableFutureTask<V>(runnable, result);
    }

    ListenableFutureTask(Callable<V> callable) {
        super(callable);
    }

    ListenableFutureTask(Runnable runnable, @ParametricNullness V result) {
        super(runnable, result);
    }

    @Override
    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public V get(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, ExecutionException {
        long timeoutNanos = unit.toNanos(timeout);
        if (timeoutNanos <= 2147483647999999999L) {
            return (V)super.get(timeout, unit);
        }
        return (V)super.get(Math.min((long)timeoutNanos, (long)2147483647999999999L), TimeUnit.NANOSECONDS);
    }

    protected void done() {
        this.executionList.execute();
    }
}

