/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.LazyInit;
import org.rascalmpl.com.google.j2objc.annotations.RetainedWith;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Error;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.ArrayDeque;
import org.rascalmpl.java.util.Deque;
import org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.java.util.concurrent.RejectedExecutionException;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class SequentialExecutor
extends org.rascalmpl.java.lang.Object
implements Executor {
    private static final LazyLogger log = new LazyLogger((Class<?>)SequentialExecutor.class);
    private final Executor executor;
    @GuardedBy(value="org.rascalmpl.queue")
    private final Deque<Runnable> queue = new ArrayDeque();
    @LazyInit
    @GuardedBy(value="org.rascalmpl.queue")
    private WorkerRunningState workerRunningState = WorkerRunningState.IDLE;
    @GuardedBy(value="org.rascalmpl.queue")
    private long workerRunCount = 0L;
    @RetainedWith
    private final QueueWorker worker = new QueueWorker();

    SequentialExecutor(Executor executor) {
        this.executor = Preconditions.checkNotNull(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable task) {
        boolean alreadyMarkedQueued;
        Runnable submittedTask;
        long oldRunCount;
        Preconditions.checkNotNull(task);
        Deque<Runnable> deque = this.queue;
        synchronized (deque) {
            if (this.workerRunningState == WorkerRunningState.RUNNING || this.workerRunningState == WorkerRunningState.QUEUED) {
                this.queue.add((org.rascalmpl.java.lang.Object)task);
                return;
            }
            oldRunCount = this.workerRunCount;
            submittedTask = new Runnable(){

                public void run() {
                    task.run();
                }

                public String toString() {
                    return task.toString();
                }
            };
            this.queue.add((org.rascalmpl.java.lang.Object)submittedTask);
            this.workerRunningState = WorkerRunningState.QUEUING;
        }
        try {
            this.executor.execute((Runnable)this.worker);
        }
        catch (Throwable t2) {
            Deque<Runnable> deque2 = this.queue;
            synchronized (deque2) {
                boolean removed;
                boolean bl = removed = (this.workerRunningState == WorkerRunningState.IDLE || this.workerRunningState == WorkerRunningState.QUEUING) && this.queue.removeLastOccurrence((org.rascalmpl.java.lang.Object)submittedTask);
                if (!(t2 instanceof RejectedExecutionException) || removed) {
                    throw t2;
                }
            }
            return;
        }
        boolean bl = alreadyMarkedQueued = this.workerRunningState != WorkerRunningState.QUEUING;
        if (alreadyMarkedQueued) {
            return;
        }
        Deque<Runnable> deque3 = this.queue;
        synchronized (deque3) {
            if (this.workerRunCount == oldRunCount && this.workerRunningState == WorkerRunningState.QUEUING) {
                this.workerRunningState = WorkerRunningState.QUEUED;
            }
        }
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.SequentialExecutor@").append(System.identityHashCode((org.rascalmpl.java.lang.Object)this)).append((String)"org.rascalmpl.{").append((org.rascalmpl.java.lang.Object)this.executor).append((String)"org.rascalmpl.}").toString();
    }

    private final class QueueWorker
    extends org.rascalmpl.java.lang.Object
    implements Runnable {
        @CheckForNull
        Runnable task;

        private QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.workOnQueue();
            }
            catch (Error e) {
                Deque deque = SequentialExecutor.this.queue;
                synchronized (deque) {
                    SequentialExecutor.this.workerRunningState = WorkerRunningState.IDLE;
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void workOnQueue() {
            boolean interruptedDuringTask = false;
            boolean hasSetRunning = false;
            while (true) {
                block14: {
                    block15: {
                        try {
                            Deque deque = SequentialExecutor.this.queue;
                            // MONITORENTER : deque
                            if (hasSetRunning) break block14;
                            if (SequentialExecutor.this.workerRunningState != WorkerRunningState.RUNNING) break block15;
                            // MONITOREXIT : deque
                            if (!interruptedDuringTask) return;
                        }
                        catch (java.lang.Throwable throwable) {
                            if (!interruptedDuringTask) throw throwable;
                            Thread.currentThread().interrupt();
                            throw throwable;
                        }
                        Thread.currentThread().interrupt();
                        return;
                    }
                    SequentialExecutor.this.workerRunCount++;
                    SequentialExecutor.this.workerRunningState = WorkerRunningState.RUNNING;
                    hasSetRunning = true;
                }
                this.task = (Runnable)SequentialExecutor.this.queue.poll();
                if (this.task == null) {
                    SequentialExecutor.this.workerRunningState = WorkerRunningState.IDLE;
                    // MONITOREXIT : deque
                    if (!interruptedDuringTask) return;
                    Thread.currentThread().interrupt();
                    return;
                }
                // MONITOREXIT : deque
                interruptedDuringTask |= Thread.interrupted();
                try {
                    this.task.run();
                    continue;
                }
                catch (Exception e) {
                    log.get().log(Level.SEVERE, new StringBuilder().append((String)"org.rascalmpl.Exception while executing runnable ").append((org.rascalmpl.java.lang.Object)this.task).toString(), (Throwable)((Object)e));
                    continue;
                }
                finally {
                    this.task = null;
                    continue;
                }
                break;
            }
        }

        public String toString() {
            Runnable currentlyRunning = this.task;
            if (currentlyRunning != null) {
                return new StringBuilder().append((String)"org.rascalmpl.SequentialExecutorWorker{running=").append((org.rascalmpl.java.lang.Object)currentlyRunning).append((String)"org.rascalmpl.}").toString();
            }
            return new StringBuilder().append((String)"org.rascalmpl.SequentialExecutorWorker{state=").append((org.rascalmpl.java.lang.Object)SequentialExecutor.this.workerRunningState).append((String)"org.rascalmpl.}").toString();
        }
    }

    static final class WorkerRunningState
    extends Enum<WorkerRunningState> {
        public static final /* enum */ WorkerRunningState IDLE = new WorkerRunningState((String)"org.rascalmpl.IDLE", 0);
        public static final /* enum */ WorkerRunningState QUEUING = new WorkerRunningState((String)"org.rascalmpl.QUEUING", 1);
        public static final /* enum */ WorkerRunningState QUEUED = new WorkerRunningState((String)"org.rascalmpl.QUEUED", 2);
        public static final /* enum */ WorkerRunningState RUNNING = new WorkerRunningState((String)"org.rascalmpl.RUNNING", 3);
        private static final /* synthetic */ WorkerRunningState[] $VALUES;

        public static WorkerRunningState[] values() {
            return (WorkerRunningState[])$VALUES.clone();
        }

        public static WorkerRunningState valueOf(String name) {
            return (WorkerRunningState)Enum.valueOf(WorkerRunningState.class, (String)name);
        }

        private WorkerRunningState() {
            super((String)string, n);
        }

        static {
            $VALUES = new WorkerRunningState[]{IDLE, QUEUING, QUEUED, RUNNING};
        }
    }
}

