/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Function;
import org.rascalmpl.com.google.common.base.MoreObjects;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.base.Predicates;
import org.rascalmpl.com.google.common.base.Stopwatch;
import org.rascalmpl.com.google.common.collect.Collections2;
import org.rascalmpl.com.google.common.collect.ImmutableCollection;
import org.rascalmpl.com.google.common.collect.ImmutableList;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.ImmutableSet;
import org.rascalmpl.com.google.common.collect.ImmutableSetMultimap;
import org.rascalmpl.com.google.common.collect.Lists;
import org.rascalmpl.com.google.common.collect.Maps;
import org.rascalmpl.com.google.common.collect.MultimapBuilder;
import org.rascalmpl.com.google.common.collect.Multimaps;
import org.rascalmpl.com.google.common.collect.Multiset;
import org.rascalmpl.com.google.common.collect.Ordering;
import org.rascalmpl.com.google.common.collect.SetMultimap;
import org.rascalmpl.com.google.common.util.concurrent.AbstractService;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.Internal;
import org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.com.google.common.util.concurrent.ListenerCallQueue;
import org.rascalmpl.com.google.common.util.concurrent.Monitor;
import org.rascalmpl.com.google.common.util.concurrent.MoreExecutors;
import org.rascalmpl.com.google.common.util.concurrent.Service;
import org.rascalmpl.com.google.common.util.concurrent.ServiceManagerBridge;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.ref.WeakReference;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.EnumSet;
import org.rascalmpl.java.util.IdentityHashMap;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.Executor;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.java.util.logging.Level;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class ServiceManager
extends org.rascalmpl.java.lang.Object
implements ServiceManagerBridge {
    private static final LazyLogger logger = new LazyLogger((Class<?>)ServiceManager.class);
    private static final ListenerCallQueue.Event<Listener> HEALTHY_EVENT = new ListenerCallQueue.Event<Listener>(){

        @Override
        public void call(Listener listener) {
            listener.healthy();
        }

        public String toString() {
            return "org.rascalmpl.healthy()";
        }
    };
    private static final ListenerCallQueue.Event<Listener> STOPPED_EVENT = new ListenerCallQueue.Event<Listener>(){

        @Override
        public void call(Listener listener) {
            listener.stopped();
        }

        public String toString() {
            return "org.rascalmpl.stopped()";
        }
    };
    private final ServiceManagerState state;
    private final ImmutableList<Service> services;

    public ServiceManager(Iterable<? extends Service> services) {
        ImmutableList<Service> copy = ImmutableList.copyOf(services);
        if (copy.isEmpty()) {
            logger.get().log(Level.WARNING, (String)"org.rascalmpl.ServiceManager configured with no services.  Is your application configured properly?", (Throwable)new EmptyServiceManagerWarning());
            copy = ImmutableList.of(new NoOpService());
        }
        this.state = new ServiceManagerState(copy);
        this.services = copy;
        WeakReference stateReference = new WeakReference((org.rascalmpl.java.lang.Object)this.state);
        Iterator iterator = copy.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            service.addListener(new ServiceListener(service, (WeakReference<ServiceManagerState>)stateReference), MoreExecutors.directExecutor());
            Preconditions.checkArgument(service.state() == Service.State.NEW, (String)"org.rascalmpl.Can only manage NEW services, %s", (org.rascalmpl.java.lang.Object)service);
        }
        this.state.markReady();
    }

    public void addListener(Listener listener, Executor executor) {
        this.state.addListener(listener, executor);
    }

    @CanIgnoreReturnValue
    public ServiceManager startAsync() {
        Service service;
        Iterator iterator = this.services.iterator();
        while (iterator.hasNext()) {
            service = (Service)iterator.next();
            Preconditions.checkState(service.state() == Service.State.NEW, (String)"org.rascalmpl.Not all services are NEW, cannot start %s", (org.rascalmpl.java.lang.Object)this);
        }
        iterator = this.services.iterator();
        while (iterator.hasNext()) {
            service = (Service)iterator.next();
            try {
                this.state.tryStartTiming(service);
                service.startAsync();
            }
            catch (IllegalStateException e) {
                logger.get().log(Level.WARNING, new StringBuilder().append((String)"org.rascalmpl.Unable to start Service ").append((org.rascalmpl.java.lang.Object)service).toString(), (Throwable)((Object)e));
            }
        }
        return this;
    }

    public void awaitHealthy() {
        this.state.awaitHealthy();
    }

    public void awaitHealthy(Duration timeout) throws TimeoutException {
        this.awaitHealthy(Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    public void awaitHealthy(long timeout, TimeUnit unit) throws TimeoutException {
        this.state.awaitHealthy(timeout, unit);
    }

    @CanIgnoreReturnValue
    public ServiceManager stopAsync() {
        Iterator iterator = this.services.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            service.stopAsync();
        }
        return this;
    }

    public void awaitStopped() {
        this.state.awaitStopped();
    }

    public void awaitStopped(Duration timeout) throws TimeoutException {
        this.awaitStopped(Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    public void awaitStopped(long timeout, TimeUnit unit) throws TimeoutException {
        this.state.awaitStopped(timeout, unit);
    }

    public boolean isHealthy() {
        Iterator iterator = this.services.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (service.isRunning()) continue;
            return false;
        }
        return true;
    }

    public ImmutableSetMultimap<Service.State, Service> servicesByState() {
        return this.state.servicesByState();
    }

    public ImmutableMap<Service, Long> startupTimes() {
        return this.state.startupTimes();
    }

    /*
     * Exception decompiling
     */
    public ImmutableMap<Service, Duration> startupDurations() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return MoreObjects.toStringHelper(ServiceManager.class).add((String)"org.rascalmpl.services", (org.rascalmpl.java.lang.Object)Collections2.filter(this.services, Predicates.not(Predicates.instanceOf(NoOpService.class)))).toString();
    }

    private static final class FailedService
    extends Throwable {
        FailedService(Service service) {
            super(service.toString(), service.failureCause(), false, false);
        }
    }

    private static final class EmptyServiceManagerWarning
    extends Throwable {
        private EmptyServiceManagerWarning() {
        }
    }

    private static final class NoOpService
    extends AbstractService {
        private NoOpService() {
        }

        @Override
        protected void doStart() {
            this.notifyStarted();
        }

        @Override
        protected void doStop() {
            this.notifyStopped();
        }
    }

    private static final class ServiceListener
    extends Service.Listener {
        final Service service;
        final WeakReference<ServiceManagerState> state;

        ServiceListener(Service service, WeakReference<ServiceManagerState> state) {
            this.service = service;
            this.state = state;
        }

        @Override
        public void starting() {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                state.transitionService(this.service, Service.State.NEW, Service.State.STARTING);
                if (!(this.service instanceof NoOpService)) {
                    logger.get().log(Level.FINE, (String)"org.rascalmpl.Starting {0}.", (org.rascalmpl.java.lang.Object)this.service);
                }
            }
        }

        @Override
        public void running() {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                state.transitionService(this.service, Service.State.STARTING, Service.State.RUNNING);
            }
        }

        @Override
        public void stopping(Service.State from) {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                state.transitionService(this.service, from, Service.State.STOPPING);
            }
        }

        @Override
        public void terminated(Service.State from) {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                if (!(this.service instanceof NoOpService)) {
                    logger.get().log(Level.FINE, (String)"org.rascalmpl.Service {0} has terminated. Previous state was: {1}", new org.rascalmpl.java.lang.Object[]{this.service, from});
                }
                state.transitionService(this.service, from, Service.State.TERMINATED);
            }
        }

        @Override
        public void failed(Service.State from, Throwable failure) {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                boolean log = !(this.service instanceof NoOpService);
                if (log &= from != Service.State.STARTING) {
                    logger.get().log(Level.SEVERE, new StringBuilder().append((String)"org.rascalmpl.Service ").append((org.rascalmpl.java.lang.Object)this.service).append((String)"org.rascalmpl. has failed in the ").append((org.rascalmpl.java.lang.Object)from).append((String)"org.rascalmpl. state.").toString(), failure);
                }
                state.transitionService(this.service, from, Service.State.FAILED);
            }
        }
    }

    private static final class ServiceManagerState
    extends org.rascalmpl.java.lang.Object {
        final Monitor monitor = new Monitor();
        @GuardedBy(value="org.rascalmpl.monitor")
        final SetMultimap<Service.State, Service> servicesByState = MultimapBuilder.enumKeys(Service.State.class).linkedHashSetValues().build();
        @GuardedBy(value="org.rascalmpl.monitor")
        final Multiset<Service.State> states = this.servicesByState.keys();
        @GuardedBy(value="org.rascalmpl.monitor")
        final IdentityHashMap<Service, Stopwatch> startupTimers = new IdentityHashMap();
        @GuardedBy(value="org.rascalmpl.monitor")
        boolean ready;
        @GuardedBy(value="org.rascalmpl.monitor")
        boolean transitioned;
        final int numberOfServices;
        final Monitor.Guard awaitHealthGuard = new AwaitHealthGuard();
        final Monitor.Guard stoppedGuard = new StoppedGuard();
        final ListenerCallQueue<Listener> listeners = new ListenerCallQueue();

        ServiceManagerState(ImmutableCollection<Service> services) {
            this.numberOfServices = services.size();
            this.servicesByState.putAll((org.rascalmpl.java.lang.Object)Service.State.NEW, (Iterable)services);
        }

        void tryStartTiming(Service service) {
            this.monitor.enter();
            try {
                Stopwatch stopwatch = (Stopwatch)this.startupTimers.get((org.rascalmpl.java.lang.Object)service);
                if (stopwatch == null) {
                    this.startupTimers.put((org.rascalmpl.java.lang.Object)service, (org.rascalmpl.java.lang.Object)Stopwatch.createStarted());
                }
            }
            finally {
                this.monitor.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markReady() {
            block5: {
                this.monitor.enter();
                try {
                    if (!this.transitioned) {
                        this.ready = true;
                        break block5;
                    }
                    ArrayList servicesInBadStates = Lists.newArrayList();
                    Iterator iterator = this.servicesByState().values().iterator();
                    while (iterator.hasNext()) {
                        Service service = (Service)iterator.next();
                        if (service.state() == Service.State.NEW) continue;
                        servicesInBadStates.add((org.rascalmpl.java.lang.Object)service);
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.Services started transitioning asynchronously before the ServiceManager was constructed: ").append(servicesInBadStates).toString());
                }
                finally {
                    this.monitor.leave();
                }
            }
        }

        void addListener(Listener listener, Executor executor) {
            this.listeners.addListener(listener, executor);
        }

        void awaitHealthy() {
            this.monitor.enterWhenUninterruptibly(this.awaitHealthGuard);
            try {
                this.checkHealthy();
            }
            finally {
                this.monitor.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitHealthy(long timeout, TimeUnit unit) throws TimeoutException {
            this.monitor.enter();
            try {
                if (!this.monitor.waitForUninterruptibly(this.awaitHealthGuard, timeout, unit)) {
                    throw new TimeoutException(new StringBuilder().append((String)"org.rascalmpl.Timeout waiting for the services to become healthy. The following services have not started: ").append(Multimaps.filterKeys(this.servicesByState, Predicates.in(ImmutableSet.of(Service.State.NEW, Service.State.STARTING)))).toString());
                }
                this.checkHealthy();
            }
            finally {
                this.monitor.leave();
            }
        }

        void awaitStopped() {
            this.monitor.enterWhenUninterruptibly(this.stoppedGuard);
            this.monitor.leave();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitStopped(long timeout, TimeUnit unit) throws TimeoutException {
            this.monitor.enter();
            try {
                if (!this.monitor.waitForUninterruptibly(this.stoppedGuard, timeout, unit)) {
                    throw new TimeoutException(new StringBuilder().append((String)"org.rascalmpl.Timeout waiting for the services to stop. The following services have not stopped: ").append(Multimaps.filterKeys(this.servicesByState, Predicates.not(Predicates.in(EnumSet.of((Enum)Service.State.TERMINATED, (Enum)Service.State.FAILED))))).toString());
                }
            }
            finally {
                this.monitor.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImmutableSetMultimap<Service.State, Service> servicesByState() {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            this.monitor.enter();
            try {
                for (Map.Entry entry : this.servicesByState.entries()) {
                    if (entry.getValue() instanceof NoOpService) continue;
                    builder.put(entry);
                }
            }
            finally {
                this.monitor.leave();
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImmutableMap<Service, Long> startupTimes() {
            ArrayList loadTimes;
            this.monitor.enter();
            try {
                loadTimes = Lists.newArrayListWithCapacity(this.startupTimers.size());
                for (Map.Entry entry : this.startupTimers.entrySet()) {
                    Service service = (Service)entry.getKey();
                    Stopwatch stopwatch = (Stopwatch)entry.getValue();
                    if (stopwatch.isRunning() || service instanceof NoOpService) continue;
                    loadTimes.add(Maps.immutableEntry(service, Long.valueOf((long)stopwatch.elapsed(TimeUnit.MILLISECONDS))));
                }
            }
            finally {
                this.monitor.leave();
            }
            Collections.sort(loadTimes, Ordering.natural().onResultOf(new Function<Map.Entry<Service, Long>, Long>(){

                @Override
                public Long apply(Map.Entry<Service, Long> input) {
                    return (Long)input.getValue();
                }
            }));
            return ImmutableMap.copyOf(loadTimes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void transitionService(Service service, Service.State from, Service.State to) {
            Preconditions.checkNotNull(service);
            Preconditions.checkArgument(from != to);
            this.monitor.enter();
            try {
                this.transitioned = true;
                if (!this.ready) {
                    return;
                }
                Preconditions.checkState(this.servicesByState.remove((org.rascalmpl.java.lang.Object)from, service), (String)"org.rascalmpl.Service %s not at the expected location in the state map %s", (org.rascalmpl.java.lang.Object)service, (org.rascalmpl.java.lang.Object)from);
                Preconditions.checkState(this.servicesByState.put((org.rascalmpl.java.lang.Object)to, service), (String)"org.rascalmpl.Service %s in the state map unexpectedly at %s", (org.rascalmpl.java.lang.Object)service, (org.rascalmpl.java.lang.Object)to);
                Stopwatch stopwatch = (Stopwatch)this.startupTimers.get((org.rascalmpl.java.lang.Object)service);
                if (stopwatch == null) {
                    stopwatch = Stopwatch.createStarted();
                    this.startupTimers.put((org.rascalmpl.java.lang.Object)service, (org.rascalmpl.java.lang.Object)stopwatch);
                }
                if (to.compareTo(Service.State.RUNNING) >= 0 && stopwatch.isRunning()) {
                    stopwatch.stop();
                    if (!(service instanceof NoOpService)) {
                        logger.get().log(Level.FINE, (String)"org.rascalmpl.Started {0} in {1}.", new org.rascalmpl.java.lang.Object[]{service, stopwatch});
                    }
                }
                if (to == Service.State.FAILED) {
                    this.enqueueFailedEvent(service);
                }
                if (this.states.count((org.rascalmpl.java.lang.Object)Service.State.RUNNING) == this.numberOfServices) {
                    this.enqueueHealthyEvent();
                } else if (this.states.count((org.rascalmpl.java.lang.Object)Service.State.TERMINATED) + this.states.count((org.rascalmpl.java.lang.Object)Service.State.FAILED) == this.numberOfServices) {
                    this.enqueueStoppedEvent();
                }
            }
            finally {
                this.monitor.leave();
                this.dispatchListenerEvents();
            }
        }

        void enqueueStoppedEvent() {
            this.listeners.enqueue(STOPPED_EVENT);
        }

        void enqueueHealthyEvent() {
            this.listeners.enqueue(HEALTHY_EVENT);
        }

        void enqueueFailedEvent(final Service service) {
            this.listeners.enqueue(new ListenerCallQueue.Event<Listener>(){

                @Override
                public void call(Listener listener) {
                    listener.failure(service);
                }

                public String toString() {
                    return new StringBuilder().append((String)"org.rascalmpl.failed({service=").append((org.rascalmpl.java.lang.Object)service).append((String)"org.rascalmpl.})").toString();
                }
            });
        }

        void dispatchListenerEvents() {
            Preconditions.checkState(!this.monitor.isOccupiedByCurrentThread(), (org.rascalmpl.java.lang.Object)"org.rascalmpl.It is incorrect to execute listeners with the monitor held.");
            this.listeners.dispatch();
        }

        @GuardedBy(value="org.rascalmpl.monitor")
        void checkHealthy() {
            if (this.states.count((org.rascalmpl.java.lang.Object)Service.State.RUNNING) != this.numberOfServices) {
                IllegalStateException exception = new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Expected to be healthy after starting. The following services are not running: ").append(Multimaps.filterKeys(this.servicesByState, Predicates.not(Predicates.equalTo(Service.State.RUNNING)))).toString());
                for (Service service : this.servicesByState.get(Service.State.FAILED)) {
                    exception.addSuppressed((Throwable)new FailedService(service));
                }
                throw exception;
            }
        }

        final class StoppedGuard
        extends Monitor.Guard {
            StoppedGuard() {
                super(ServiceManagerState.this.monitor);
            }

            @Override
            @GuardedBy(value="org.rascalmpl.ServiceManagerState.this.monitor")
            public boolean isSatisfied() {
                return ServiceManagerState.this.states.count((org.rascalmpl.java.lang.Object)Service.State.TERMINATED) + ServiceManagerState.this.states.count((org.rascalmpl.java.lang.Object)Service.State.FAILED) == ServiceManagerState.this.numberOfServices;
            }
        }

        final class AwaitHealthGuard
        extends Monitor.Guard {
            AwaitHealthGuard() {
                super(ServiceManagerState.this.monitor);
            }

            @Override
            @GuardedBy(value="org.rascalmpl.ServiceManagerState.this.monitor")
            public boolean isSatisfied() {
                return ServiceManagerState.this.states.count((org.rascalmpl.java.lang.Object)Service.State.RUNNING) == ServiceManagerState.this.numberOfServices || ServiceManagerState.this.states.contains((org.rascalmpl.java.lang.Object)Service.State.STOPPING) || ServiceManagerState.this.states.contains((org.rascalmpl.java.lang.Object)Service.State.TERMINATED) || ServiceManagerState.this.states.contains((org.rascalmpl.java.lang.Object)Service.State.FAILED);
            }
        }
    }

    public static abstract class Listener
    extends org.rascalmpl.java.lang.Object {
        public void healthy() {
        }

        public void stopped() {
        }

        public void failure(Service service) {
        }
    }
}

