/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.collect.ObjectArrays;
import org.rascalmpl.com.google.common.collect.Sets;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.ExecutionError;
import org.rascalmpl.com.google.common.util.concurrent.ParametricNullness;
import org.rascalmpl.com.google.common.util.concurrent.TimeLimiter;
import org.rascalmpl.com.google.common.util.concurrent.UncheckedExecutionException;
import org.rascalmpl.com.google.common.util.concurrent.UncheckedTimeoutException;
import org.rascalmpl.com.google.common.util.concurrent.Uninterruptibles;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.java.lang.Error;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.StackTraceElement;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.InvocationHandler;
import org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.lang.reflect.Proxy;
import org.rascalmpl.java.util.HashSet;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.concurrent.Callable;
import org.rascalmpl.java.util.concurrent.ExecutionException;
import org.rascalmpl.java.util.concurrent.ExecutorService;
import org.rascalmpl.java.util.concurrent.Future;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.TimeoutException;
import org.rascalmpl.javax.annotation.CheckForNull;
import org.rascalmpl.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class SimpleTimeLimiter
extends org.rascalmpl.java.lang.Object
implements TimeLimiter {
    private final ExecutorService executor;

    private SimpleTimeLimiter(ExecutorService executor) {
        this.executor = Preconditions.checkNotNull(executor);
    }

    public static SimpleTimeLimiter create(ExecutorService executor) {
        return new SimpleTimeLimiter(executor);
    }

    @Override
    public <T extends org.rascalmpl.java.lang.Object> T newProxy(final T target, Class<T> interfaceType, final long timeoutDuration, final TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Preconditions.checkArgument(interfaceType.isInterface(), (org.rascalmpl.java.lang.Object)"org.rascalmpl.interfaceType must be an interface type");
        final Set<Method> interruptibleMethods = SimpleTimeLimiter.findInterruptibleMethods(interfaceType);
        InvocationHandler handler = new InvocationHandler(){

            /*
             * Exception decompiling
             */
            @CheckForNull
            public org.rascalmpl.java.lang.Object invoke(org.rascalmpl.java.lang.Object obj, Method method, @CheckForNull @Nullable org.rascalmpl.java.lang.Object[] args) throws Throwable {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/java/lang/Object;
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
                 *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static /* synthetic */ org.rascalmpl.java.lang.Object lambda$invoke$0(Method method, org.rascalmpl.java.lang.Object target2, org.rascalmpl.java.lang.Object[] args) throws Exception {
                try {
                    return method.invoke(target2, args);
                }
                catch (InvocationTargetException e) {
                    throw SimpleTimeLimiter.throwCause((Exception)((Object)e), false);
                }
            }
        };
        return SimpleTimeLimiter.newProxy(interfaceType, handler);
    }

    private static <T extends org.rascalmpl.java.lang.Object> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        org.rascalmpl.java.lang.Object object = Proxy.newProxyInstance((ClassLoader)interfaceType.getClassLoader(), (Class[])new Class[]{interfaceType}, (InvocationHandler)handler);
        return (T)interfaceType.cast(object);
    }

    @ParametricNullness
    private <T extends org.rascalmpl.java.lang.Object> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit, boolean amInterruptible) throws Exception {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future future = this.executor.submit(callable);
        try {
            return (T)(amInterruptible ? future.get(timeoutDuration, timeoutUnit) : Uninterruptibles.getUninterruptibly(future, timeoutDuration, timeoutUnit));
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw SimpleTimeLimiter.throwCause((Exception)((Object)e), true);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new UncheckedTimeoutException((Throwable)((Object)e));
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T extends org.rascalmpl.java.lang.Object> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future future = this.executor.submit(callable);
        try {
            return (T)future.get(timeoutDuration, timeoutUnit);
        }
        catch (InterruptedException | TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            this.wrapAndThrowExecutionExceptionOrError(e.getCause());
            throw new AssertionError();
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T extends org.rascalmpl.java.lang.Object> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future future = this.executor.submit(callable);
        try {
            return (T)Uninterruptibles.getUninterruptibly(future, timeoutDuration, timeoutUnit);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            this.wrapAndThrowExecutionExceptionOrError(e.getCause());
            throw new AssertionError();
        }
    }

    @Override
    public void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future future = this.executor.submit(runnable);
        try {
            future.get(timeoutDuration, timeoutUnit);
        }
        catch (InterruptedException | TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            this.wrapAndThrowRuntimeExecutionExceptionOrError(e.getCause());
            throw new AssertionError();
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future future = this.executor.submit(runnable);
        try {
            Uninterruptibles.getUninterruptibly(future, timeoutDuration, timeoutUnit);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            this.wrapAndThrowRuntimeExecutionExceptionOrError(e.getCause());
            throw new AssertionError();
        }
    }

    private static Exception throwCause(Exception e, boolean combineStackTraces) throws Exception {
        Throwable cause = e.getCause();
        if (cause == null) {
            throw e;
        }
        if (combineStackTraces) {
            StackTraceElement[] combined = (StackTraceElement[])ObjectArrays.concat((org.rascalmpl.java.lang.Object[])cause.getStackTrace(), (org.rascalmpl.java.lang.Object[])e.getStackTrace(), StackTraceElement.class);
            cause.setStackTrace(combined);
        }
        if (cause instanceof Exception) {
            throw (Exception)((Object)cause);
        }
        if (cause instanceof Error) {
            throw (Error)((Object)cause);
        }
        throw e;
    }

    private static Set<Method> findInterruptibleMethods(Class<?> interfaceType) {
        HashSet set = Sets.newHashSet();
        for (Method m4 : interfaceType.getMethods()) {
            if (!SimpleTimeLimiter.declaresInterruptedEx(m4)) continue;
            set.add((org.rascalmpl.java.lang.Object)m4);
        }
        return set;
    }

    private static boolean declaresInterruptedEx(Method method) {
        for (Class exType : method.getExceptionTypes()) {
            if (exType != InterruptedException.class) continue;
            return true;
        }
        return false;
    }

    private void wrapAndThrowExecutionExceptionOrError(Throwable cause) throws ExecutionException {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)((Object)cause));
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw new ExecutionException(cause);
    }

    private void wrapAndThrowRuntimeExecutionExceptionOrError(Throwable cause) {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)((Object)cause));
        }
        throw new UncheckedExecutionException(cause);
    }

    private static void checkPositiveTimeout(long timeoutDuration) {
        Preconditions.checkArgument(timeoutDuration > 0L, (String)"org.rascalmpl.timeout must be positive: %s", timeoutDuration);
    }

    static /* synthetic */ org.rascalmpl.java.lang.Object access$000(SimpleTimeLimiter x0, Callable x1, long x2, TimeUnit x3, boolean x4) throws Exception {
        return x0.callWithTimeout(x1, x2, x3, x4);
    }
}

