/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.base.Preconditions;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.util.Locale;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.java.util.concurrent.atomic.AtomicLong;
import org.rascalmpl.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class ThreadFactoryBuilder
extends Object {
    @CheckForNull
    private String nameFormat = null;
    @CheckForNull
    private Boolean daemon = null;
    @CheckForNull
    private Integer priority = null;
    @CheckForNull
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    @CheckForNull
    private ThreadFactory backingThreadFactory = null;

    @CanIgnoreReturnValue
    public ThreadFactoryBuilder setNameFormat(String nameFormat) {
        String unused = ThreadFactoryBuilder.format(nameFormat, new Object[]{Integer.valueOf((int)0)});
        this.nameFormat = nameFormat;
        return this;
    }

    @CanIgnoreReturnValue
    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = Boolean.valueOf((boolean)daemon);
        return this;
    }

    @CanIgnoreReturnValue
    public ThreadFactoryBuilder setPriority(int priority) {
        Preconditions.checkArgument(priority >= 1, (String)"org.rascalmpl.Thread priority (%s) must be >= %s", priority, 1);
        Preconditions.checkArgument(priority <= 10, (String)"org.rascalmpl.Thread priority (%s) must be <= %s", priority, 10);
        this.priority = Integer.valueOf((int)priority);
        return this;
    }

    @CanIgnoreReturnValue
    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler);
        return this;
    }

    @CanIgnoreReturnValue
    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = Preconditions.checkNotNull(backingThreadFactory);
        return this;
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.doBuild(this);
    }

    private static ThreadFactory doBuild(ThreadFactoryBuilder builder) {
        final String nameFormat = builder.nameFormat;
        final Boolean daemon = builder.daemon;
        final Integer priority = builder.priority;
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = builder.uncaughtExceptionHandler;
        final ThreadFactory backingThreadFactory = builder.backingThreadFactory != null ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        final AtomicLong count = nameFormat != null ? new AtomicLong(0L) : null;
        return new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                Objects.requireNonNull((Object)thread);
                if (nameFormat != null) {
                    thread.setName(ThreadFactoryBuilder.format(nameFormat, new Object[]{Long.valueOf((long)((AtomicLong)Objects.requireNonNull((Object)count)).getAndIncrement())}));
                }
                if (daemon != null) {
                    thread.setDaemon(daemon.booleanValue());
                }
                if (priority != null) {
                    thread.setPriority(priority.intValue());
                }
                if (uncaughtExceptionHandler != null) {
                    thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                }
                return thread;
            }
        };
    }

    private static String format(String format, Object ... args) {
        return String.format((Locale)Locale.ROOT, (String)format, (Object[])args);
    }
}

