/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.common.util.concurrent;

import org.rascalmpl.com.google.common.annotations.GwtIncompatible;
import org.rascalmpl.com.google.common.annotations.J2ktIncompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.rascalmpl.com.google.common.util.concurrent.LazyLogger;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runtime;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Locale;
import org.rascalmpl.java.util.logging.Level;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class UncaughtExceptionHandlers
extends Object {
    private UncaughtExceptionHandlers() {
    }

    public static Thread.UncaughtExceptionHandler systemExit() {
        return new Exiter(Runtime.getRuntime());
    }

    @VisibleForTesting
    static final class Exiter
    extends Object
    implements Thread.UncaughtExceptionHandler {
        private static final LazyLogger logger = new LazyLogger((Class<?>)Exiter.class);
        private final Runtime runtime;

        Exiter(Runtime runtime) {
            this.runtime = runtime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uncaughtException(Thread t2, Throwable e) {
            try {
                logger.get().log(Level.SEVERE, String.format((Locale)Locale.ROOT, (String)"org.rascalmpl.Caught an exception in %s.  Shutting down.", (Object[])new Object[]{t2}), e);
            }
            catch (Throwable errorInLogging) {
                System.err.println(e.getMessage());
                System.err.println(errorInLogging.getMessage());
            }
            finally {
                this.runtime.exit(1);
            }
        }
    }
}

