/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.com.google.thirdparty.publicsuffix;

import org.rascalmpl.com.google.common.annotations.GwtCompatible;
import org.rascalmpl.com.google.common.annotations.VisibleForTesting;
import org.rascalmpl.com.google.common.base.Joiner;
import org.rascalmpl.com.google.common.collect.ImmutableMap;
import org.rascalmpl.com.google.common.collect.Queues;
import org.rascalmpl.com.google.thirdparty.publicsuffix.PublicSuffixType;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Deque;

@GwtCompatible
final class TrieParser
extends Object {
    private static final Joiner DIRECT_JOINER = Joiner.on((String)"org.rascalmpl.");

    TrieParser() {
    }

    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence ... encodedChunks) {
        String encoded = DIRECT_JOINER.join((Object[])encodedChunks);
        return TrieParser.parseFullString(encoded);
    }

    @VisibleForTesting
    static ImmutableMap<String, PublicSuffixType> parseFullString(String encoded) {
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int encodedLen = encoded.length();
        for (int idx = 0; idx < encodedLen; idx += TrieParser.doParseTrieToBuilder(Queues.newArrayDeque(), (CharSequence)encoded, idx, builder)) {
        }
        return builder.buildOrThrow();
    }

    private static int doParseTrieToBuilder(Deque<CharSequence> stack, CharSequence encoded, int start, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        String domain;
        int idx;
        int encodedLen = encoded.length();
        char c = '\u0000';
        for (idx = start; idx < encodedLen && (c = encoded.charAt(idx)) != '&' && c != '?' && c != '!' && c != ':' && c != ','; ++idx) {
        }
        stack.push((Object)TrieParser.reverse(encoded.subSequence(start, idx)));
        if ((c == '!' || c == '?' || c == ':' || c == ',') && (domain = DIRECT_JOINER.join((Iterable<? extends Object>)stack)).length() > 0) {
            builder.put(domain, PublicSuffixType.fromCode(c));
        }
        ++idx;
        if (c != '?' && c != ',') {
            while (idx < encodedLen) {
                if (encoded.charAt(idx += TrieParser.doParseTrieToBuilder(stack, encoded, idx, builder)) != '?' && encoded.charAt(idx) != ',') continue;
                ++idx;
                break;
            }
        }
        stack.pop();
        return idx - start;
    }

    private static CharSequence reverse(CharSequence s2) {
        return new StringBuilder(s2).reverse();
    }
}

