/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe;

import org.rascalmpl.dev.failsafe.DelayablePolicyConfig;
import org.rascalmpl.dev.failsafe.event.CircuitBreakerStateChangedEvent;
import org.rascalmpl.dev.failsafe.event.EventListener;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.time.Duration;

public class CircuitBreakerConfig<R extends Object>
extends DelayablePolicyConfig<R> {
    int failureThreshold;
    int failureRateThreshold;
    int failureThresholdingCapacity;
    int failureExecutionThreshold;
    Duration failureThresholdingPeriod;
    int successThreshold;
    int successThresholdingCapacity;
    EventListener<CircuitBreakerStateChangedEvent> openListener;
    EventListener<CircuitBreakerStateChangedEvent> halfOpenListener;
    EventListener<CircuitBreakerStateChangedEvent> closeListener;

    CircuitBreakerConfig() {
    }

    CircuitBreakerConfig(CircuitBreakerConfig<R> config) {
        super(config);
        this.failureThreshold = config.failureThreshold;
        this.failureRateThreshold = config.failureRateThreshold;
        this.failureThresholdingCapacity = config.failureThresholdingCapacity;
        this.failureExecutionThreshold = config.failureExecutionThreshold;
        this.failureThresholdingPeriod = config.failureThresholdingPeriod;
        this.successThreshold = config.successThreshold;
        this.successThresholdingCapacity = config.successThresholdingCapacity;
        this.openListener = config.openListener;
        this.halfOpenListener = config.halfOpenListener;
        this.closeListener = config.closeListener;
    }

    @Override
    public Duration getDelay() {
        return this.delay;
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    public int getFailureThresholdingCapacity() {
        return this.failureThresholdingCapacity;
    }

    public int getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public Duration getFailureThresholdingPeriod() {
        return this.failureThresholdingPeriod;
    }

    public int getFailureExecutionThreshold() {
        return this.failureExecutionThreshold;
    }

    public int getSuccessThreshold() {
        return this.successThreshold;
    }

    public int getSuccessThresholdingCapacity() {
        return this.successThresholdingCapacity;
    }

    public EventListener<CircuitBreakerStateChangedEvent> getOpenListener() {
        return this.openListener;
    }

    public EventListener<CircuitBreakerStateChangedEvent> getHalfOpenListener() {
        return this.halfOpenListener;
    }

    public EventListener<CircuitBreakerStateChangedEvent> getCloseListener() {
        return this.closeListener;
    }
}

