/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe;

import org.rascalmpl.dev.failsafe.DelayablePolicyConfig;
import org.rascalmpl.dev.failsafe.FailurePolicyBuilder;
import org.rascalmpl.dev.failsafe.function.ContextualSupplier;
import org.rascalmpl.dev.failsafe.internal.util.Assert;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;

public abstract class DelayablePolicyBuilder<S extends Object, C extends DelayablePolicyConfig<R>, R extends Object>
extends FailurePolicyBuilder<S, C, R> {
    protected DelayablePolicyBuilder(C config) {
        super(config);
    }

    public S withDelay(Duration delay) {
        Assert.notNull(delay, (String)"org.rascalmpl.delay");
        Assert.isTrue(delay.toNanos() > 0L, (String)"org.rascalmpl.delay must be greater than 0", new Object[0]);
        ((DelayablePolicyConfig)this.config).delay = delay;
        return (S)((java.lang.Object)this);
    }

    public S withDelayFn(ContextualSupplier<R, Duration> delayFunction) {
        Assert.notNull(delayFunction, (String)"org.rascalmpl.delayFunction");
        ((DelayablePolicyConfig)this.config).delayFn = delayFunction;
        return (S)((java.lang.Object)this);
    }

    public <F extends Throwable> S withDelayFnOn(ContextualSupplier<R, Duration> delayFunction, Class<F> exception) {
        this.withDelayFn(delayFunction);
        Assert.notNull(exception, (String)"org.rascalmpl.exception");
        ((DelayablePolicyConfig)this.config).delayException = exception;
        return (S)((java.lang.Object)this);
    }

    public S withDelayFnWhen(ContextualSupplier<R, Duration> delayFunction, R result) {
        this.withDelayFn(delayFunction);
        Assert.notNull(result, (String)"org.rascalmpl.result");
        ((DelayablePolicyConfig)this.config).delayResult = result;
        return (S)((java.lang.Object)this);
    }
}

