/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe;

import org.rascalmpl.dev.failsafe.DelayablePolicyBuilder;
import org.rascalmpl.dev.failsafe.PolicyListeners;
import org.rascalmpl.dev.failsafe.RetryPolicy;
import org.rascalmpl.dev.failsafe.RetryPolicyConfig;
import org.rascalmpl.dev.failsafe.event.EventListener;
import org.rascalmpl.dev.failsafe.event.ExecutionAttemptedEvent;
import org.rascalmpl.dev.failsafe.event.ExecutionCompletedEvent;
import org.rascalmpl.dev.failsafe.event.ExecutionScheduledEvent;
import org.rascalmpl.dev.failsafe.function.CheckedBiPredicate;
import org.rascalmpl.dev.failsafe.function.CheckedPredicate;
import org.rascalmpl.dev.failsafe.internal.RetryPolicyImpl;
import org.rascalmpl.dev.failsafe.internal.util.Assert;
import org.rascalmpl.dev.failsafe.internal.util.Durations;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.SafeVarargs;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.time.temporal.ChronoUnit;
import org.rascalmpl.java.time.temporal.TemporalUnit;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.List;

public class RetryPolicyBuilder<R extends org.rascalmpl.java.lang.Object>
extends DelayablePolicyBuilder<RetryPolicyBuilder<R>, RetryPolicyConfig<R>, R>
implements PolicyListeners<RetryPolicyBuilder<R>, R> {
    private static final int DEFAULT_MAX_RETRIES = 2;

    RetryPolicyBuilder() {
        super(new RetryPolicyConfig());
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxRetries = 2;
        ((RetryPolicyConfig)this.config).abortConditions = new ArrayList();
    }

    RetryPolicyBuilder(RetryPolicyConfig<R> config) {
        super(new RetryPolicyConfig<R>(config));
    }

    public RetryPolicy<R> build() {
        return new RetryPolicyImpl(new RetryPolicyConfig((RetryPolicyConfig)this.config));
    }

    public RetryPolicyBuilder<R> abortIf(CheckedBiPredicate<R, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, (String)"org.rascalmpl.completionPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(completionPredicate);
        return this;
    }

    public RetryPolicyBuilder<R> abortIf(CheckedPredicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, (String)"org.rascalmpl.resultPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> exception) {
        Assert.notNull(exception, (String)"org.rascalmpl.exception");
        return this.abortOn((List<Class<Throwable>>)Arrays.asList((org.rascalmpl.java.lang.Object[])new Class[]{exception}));
    }

    @SafeVarargs
    public final RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> ... exceptions) {
        Assert.notNull(exceptions, (String)"org.rascalmpl.exceptions");
        Assert.isTrue(exceptions.length > 0, (String)"org.rascalmpl.exceptions cannot be empty", new org.rascalmpl.java.lang.Object[0]);
        return this.abortOn((List<Class<Throwable>>)Arrays.asList(exceptions));
    }

    public RetryPolicyBuilder<R> abortOn(List<Class<? extends Throwable>> exceptions) {
        Assert.notNull(exceptions, (String)"org.rascalmpl.exceptions");
        Assert.isTrue(!exceptions.isEmpty(), (String)"org.rascalmpl.exceptions cannot be empty", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(exceptions));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(CheckedPredicate<? extends Throwable> abortPredicate) {
        Assert.notNull(abortPredicate, (String)"org.rascalmpl.abortPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(abortPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortWhen(R result) {
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(result));
        return this;
    }

    public RetryPolicyBuilder<R> onAbort(EventListener<ExecutionCompletedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).abortListener = Assert.notNull(listener, (String)"org.rascalmpl.listener");
        return this;
    }

    public RetryPolicyBuilder<R> onFailedAttempt(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).failedAttemptListener = Assert.notNull(listener, (String)"org.rascalmpl.listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetriesExceeded(EventListener<ExecutionCompletedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retriesExceededListener = Assert.notNull(listener, (String)"org.rascalmpl.listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetry(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retryListener = Assert.notNull(listener, (String)"org.rascalmpl.listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetryScheduled(EventListener<ExecutionScheduledEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retryScheduledListener = Assert.notNull(listener, (String)"org.rascalmpl.listener");
        return this;
    }

    public RetryPolicyBuilder<R> withBackoff(Duration delay, Duration maxDelay) {
        return this.withBackoff(delay, maxDelay, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit) {
        return this.withBackoff(delay, maxDelay, chronoUnit, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit, double delayFactor) {
        return this.withBackoff(Duration.of((long)delay, (TemporalUnit)chronoUnit), Duration.of((long)maxDelay, (TemporalUnit)chronoUnit), delayFactor);
    }

    public RetryPolicyBuilder<R> withBackoff(Duration delay, Duration maxDelay, double delayFactor) {
        Assert.notNull(delay, (String)"org.rascalmpl.delay");
        Assert.notNull(maxDelay, (String)"org.rascalmpl.maxDelay");
        delay = Durations.ofSafeNanos(delay);
        maxDelay = Durations.ofSafeNanos(maxDelay);
        Assert.isTrue(!delay.isNegative() && !delay.isZero(), (String)"org.rascalmpl.The delay must be > 0", new org.rascalmpl.java.lang.Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), (String)"org.rascalmpl.delay must be < the maxDuration", new org.rascalmpl.java.lang.Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delay.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), (String)"org.rascalmpl.delay must be >= the jitter duration", new org.rascalmpl.java.lang.Object[0]);
        Assert.isTrue(delay.toNanos() < maxDelay.toNanos(), (String)"org.rascalmpl.delay must be < the maxDelay", new org.rascalmpl.java.lang.Object[0]);
        Assert.isTrue(delayFactor > 1.0, (String)"org.rascalmpl.delayFactor must be > 1", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).delay = delay;
        ((RetryPolicyConfig)this.config).maxDelay = maxDelay;
        ((RetryPolicyConfig)this.config).delayFactor = delayFactor;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    @Override
    public RetryPolicyBuilder<R> withDelay(Duration delay) {
        Assert.notNull(delay, (String)"org.rascalmpl.delay");
        delay = Durations.ofSafeNanos(delay);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), (String)"org.rascalmpl.delay must be < the maxDuration", new org.rascalmpl.java.lang.Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delay.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), (String)"org.rascalmpl.delay must be >= the jitter duration", new org.rascalmpl.java.lang.Object[0]);
        super.withDelay(delay);
        ((RetryPolicyConfig)this.config).maxDelay = null;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    public RetryPolicyBuilder<R> withDelay(long delayMin, long delayMax, ChronoUnit chronoUnit) {
        return this.withDelay(Duration.of((long)delayMin, (TemporalUnit)chronoUnit), Duration.of((long)delayMax, (TemporalUnit)chronoUnit));
    }

    public RetryPolicyBuilder<R> withDelay(Duration delayMin, Duration delayMax) {
        Assert.notNull(delayMin, (String)"org.rascalmpl.delayMin");
        Assert.notNull(delayMax, (String)"org.rascalmpl.delayMax");
        delayMin = Durations.ofSafeNanos(delayMin);
        delayMax = Durations.ofSafeNanos(delayMax);
        Assert.isTrue(!delayMin.isNegative() && !delayMin.isZero(), (String)"org.rascalmpl.delayMin must be > 0", new org.rascalmpl.java.lang.Object[0]);
        Assert.isTrue(!delayMax.isNegative() && !delayMax.isZero(), (String)"org.rascalmpl.delayMax must be > 0", new org.rascalmpl.java.lang.Object[0]);
        Assert.isTrue(delayMin.toNanos() < delayMax.toNanos(), (String)"org.rascalmpl.delayMin must be < delayMax", new org.rascalmpl.java.lang.Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delayMax.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), (String)"org.rascalmpl.delayMax must be < the maxDuration", new org.rascalmpl.java.lang.Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delayMin.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), (String)"org.rascalmpl.delayMin must be >= the jitter duration", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).delayMin = delayMin;
        ((RetryPolicyConfig)this.config).delayMax = delayMax;
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxDelay = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(double jitterFactor) {
        Assert.isTrue(jitterFactor >= 0.0 && jitterFactor <= 1.0, (String)"org.rascalmpl.jitterFactor must be >= 0 and <= 1", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).jitterFactor = jitterFactor;
        ((RetryPolicyConfig)this.config).jitter = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(Duration jitter) {
        Assert.notNull(jitter, (String)"org.rascalmpl.jitter");
        jitter = Durations.ofSafeNanos(jitter);
        Assert.isTrue(jitter.toNanos() > 0L, (String)"org.rascalmpl.jitter must be > 0", new org.rascalmpl.java.lang.Object[0]);
        boolean validJitter = ((RetryPolicyConfig)this.config).delayMin != null ? jitter.toNanos() <= ((RetryPolicyConfig)this.config).delayMin.toNanos() : ((RetryPolicyConfig)this.config).delay == Duration.ZERO || jitter.toNanos() < ((RetryPolicyConfig)this.config).delay.toNanos();
        Assert.state(validJitter, (String)"org.rascalmpl.jitter must be < the minimum configured delay", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).jitter = jitter;
        ((RetryPolicyConfig)this.config).jitterFactor = 0.0;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxAttempts(int maxAttempts) {
        Assert.isTrue(maxAttempts != 0, (String)"org.rascalmpl.maxAttempts cannot be 0", new org.rascalmpl.java.lang.Object[0]);
        Assert.isTrue(maxAttempts >= -1, (String)"org.rascalmpl.maxAttempts must be >= -1", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxAttempts == -1 ? -1 : maxAttempts - 1;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, (String)"org.rascalmpl.maxDuration");
        maxDuration = Durations.ofSafeNanos(maxDuration);
        Assert.state(maxDuration.toNanos() > ((RetryPolicyConfig)this.config).delay.toNanos(), (String)"org.rascalmpl.maxDuration must be > the delay", new org.rascalmpl.java.lang.Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delayMax == null || maxDuration.toNanos() > ((RetryPolicyConfig)this.config).delayMax.toNanos(), (String)"org.rascalmpl.maxDuration must be > the max random delay", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).maxDuration = maxDuration;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, (String)"org.rascalmpl.maxRetries must be >= to -1", new org.rascalmpl.java.lang.Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxRetries;
        return this;
    }
}

