/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe;

import org.rascalmpl.dev.failsafe.DelayablePolicyConfig;
import org.rascalmpl.dev.failsafe.event.EventListener;
import org.rascalmpl.dev.failsafe.event.ExecutionAttemptedEvent;
import org.rascalmpl.dev.failsafe.event.ExecutionCompletedEvent;
import org.rascalmpl.dev.failsafe.event.ExecutionScheduledEvent;
import org.rascalmpl.dev.failsafe.function.CheckedBiPredicate;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.List;

public class RetryPolicyConfig<R extends Object>
extends DelayablePolicyConfig<R> {
    Duration delayMin;
    Duration delayMax;
    double delayFactor;
    Duration maxDelay;
    Duration jitter;
    double jitterFactor;
    Duration maxDuration;
    int maxRetries;
    List<CheckedBiPredicate<R, Throwable>> abortConditions;
    EventListener<ExecutionCompletedEvent<R>> abortListener;
    EventListener<ExecutionAttemptedEvent<R>> failedAttemptListener;
    EventListener<ExecutionCompletedEvent<R>> retriesExceededListener;
    EventListener<ExecutionAttemptedEvent<R>> retryListener;
    EventListener<ExecutionScheduledEvent<R>> retryScheduledListener;

    RetryPolicyConfig() {
    }

    RetryPolicyConfig(RetryPolicyConfig<R> config) {
        super(config);
        this.delayMin = config.delayMin;
        this.delayMax = config.delayMax;
        this.delayFactor = config.delayFactor;
        this.maxDelay = config.maxDelay;
        this.jitter = config.jitter;
        this.jitterFactor = config.jitterFactor;
        this.maxDuration = config.maxDuration;
        this.maxRetries = config.maxRetries;
        this.abortConditions = new ArrayList(config.abortConditions);
        this.abortListener = config.abortListener;
        this.failedAttemptListener = config.failedAttemptListener;
        this.retriesExceededListener = config.retriesExceededListener;
        this.retryListener = config.retryListener;
        this.retryScheduledListener = config.retryScheduledListener;
    }

    public boolean allowsRetries() {
        int maxRetries = this.getMaxRetries();
        Duration maxDuration = this.getMaxDuration();
        return !(maxRetries != -1 && maxRetries <= 0 || maxDuration != null && maxDuration.toNanos() <= 0L);
    }

    public List<CheckedBiPredicate<R, Throwable>> getAbortConditions() {
        return this.abortConditions;
    }

    @Override
    public Duration getDelay() {
        return super.getDelay();
    }

    public Duration getDelayMin() {
        return this.delayMin;
    }

    public Duration getDelayMax() {
        return this.delayMax;
    }

    public double getDelayFactor() {
        return this.delayFactor;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public int getMaxAttempts() {
        return this.maxRetries == -1 ? -1 : this.maxRetries + 1;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public EventListener<ExecutionCompletedEvent<R>> getAbortListener() {
        return this.abortListener;
    }

    public EventListener<ExecutionAttemptedEvent<R>> getFailedAttemptListener() {
        return this.failedAttemptListener;
    }

    public EventListener<ExecutionCompletedEvent<R>> getRetriesExceededListener() {
        return this.retriesExceededListener;
    }

    public EventListener<ExecutionAttemptedEvent<R>> getRetryListener() {
        return this.retryListener;
    }

    public EventListener<ExecutionScheduledEvent<R>> getRetryScheduledListener() {
        return this.retryScheduledListener;
    }
}

