/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe;

import org.rascalmpl.dev.failsafe.Policy;
import org.rascalmpl.dev.failsafe.TimeoutBuilder;
import org.rascalmpl.dev.failsafe.TimeoutConfig;
import org.rascalmpl.dev.failsafe.internal.TimeoutImpl;
import org.rascalmpl.dev.failsafe.internal.util.Assert;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Duration;

public interface Timeout<R extends Object>
extends Policy<R> {
    public static <R extends Object> TimeoutBuilder<R> builder(Duration timeout) {
        Assert.notNull(timeout, (String)"org.rascalmpl.timeout");
        Assert.isTrue(timeout.toNanos() > 0L, (String)"org.rascalmpl.timeout must be > 0", new Object[0]);
        return new TimeoutBuilder(timeout);
    }

    public static <R extends Object> TimeoutBuilder<R> builder(TimeoutConfig<R> config) {
        return new TimeoutBuilder<R>(config);
    }

    public static <R extends Object> Timeout<R> of(Duration timeout) {
        return new TimeoutImpl(new TimeoutConfig(timeout, false));
    }

    @Override
    public TimeoutConfig<R> getConfig();
}

