/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe.internal;

import org.rascalmpl.dev.failsafe.CircuitBreaker;
import org.rascalmpl.dev.failsafe.CircuitBreakerConfig;
import org.rascalmpl.dev.failsafe.ExecutionContext;
import org.rascalmpl.dev.failsafe.event.CircuitBreakerStateChangedEvent;
import org.rascalmpl.dev.failsafe.event.EventListener;
import org.rascalmpl.dev.failsafe.internal.CircuitBreakerExecutor;
import org.rascalmpl.dev.failsafe.internal.CircuitState;
import org.rascalmpl.dev.failsafe.internal.ClosedState;
import org.rascalmpl.dev.failsafe.internal.HalfOpenState;
import org.rascalmpl.dev.failsafe.internal.OpenState;
import org.rascalmpl.dev.failsafe.spi.DelayablePolicy;
import org.rascalmpl.dev.failsafe.spi.FailurePolicy;
import org.rascalmpl.dev.failsafe.spi.PolicyExecutor;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.concurrent.atomic.AtomicReference;

public class CircuitBreakerImpl<R extends Object>
extends Object
implements CircuitBreaker<R>,
FailurePolicy<R>,
DelayablePolicy<R> {
    private final CircuitBreakerConfig<R> config;
    protected final AtomicReference<CircuitState<R>> state = new AtomicReference();

    public CircuitBreakerImpl(CircuitBreakerConfig<R> config) {
        this.config = config;
        this.state.set(new ClosedState(this));
    }

    @Override
    public CircuitBreakerConfig<R> getConfig() {
        return this.config;
    }

    @Override
    public boolean tryAcquirePermit() {
        return ((CircuitState)this.state.get()).tryAcquirePermit();
    }

    @Override
    public void close() {
        this.transitionTo(CircuitBreaker.State.CLOSED, this.config.getCloseListener(), null);
    }

    @Override
    public CircuitBreaker.State getState() {
        return ((CircuitState)this.state.get()).getState();
    }

    @Override
    public int getExecutionCount() {
        return ((CircuitState)this.state.get()).getStats().getExecutionCount();
    }

    @Override
    public Duration getRemainingDelay() {
        return ((CircuitState)this.state.get()).getRemainingDelay();
    }

    @Override
    public long getFailureCount() {
        return ((CircuitState)this.state.get()).getStats().getFailureCount();
    }

    @Override
    public int getFailureRate() {
        return ((CircuitState)this.state.get()).getStats().getFailureRate();
    }

    @Override
    public int getSuccessCount() {
        return ((CircuitState)this.state.get()).getStats().getSuccessCount();
    }

    @Override
    public int getSuccessRate() {
        return ((CircuitState)this.state.get()).getStats().getSuccessRate();
    }

    @Override
    public void halfOpen() {
        this.transitionTo(CircuitBreaker.State.HALF_OPEN, this.config.getHalfOpenListener(), null);
    }

    @Override
    public boolean isClosed() {
        return CircuitBreaker.State.CLOSED.equals((Object)this.getState());
    }

    @Override
    public boolean isHalfOpen() {
        return CircuitBreaker.State.HALF_OPEN.equals((Object)this.getState());
    }

    @Override
    public boolean isOpen() {
        return CircuitBreaker.State.OPEN.equals((Object)this.getState());
    }

    @Override
    public void open() {
        this.transitionTo(CircuitBreaker.State.OPEN, this.config.getOpenListener(), null);
    }

    @Override
    public void recordFailure() {
        this.recordExecutionFailure(null);
    }

    @Override
    public void recordException(Throwable exception) {
        this.recordResult(null, exception);
    }

    @Override
    public void recordResult(R result) {
        this.recordResult(result, null);
    }

    @Override
    public void recordSuccess() {
        ((CircuitState)this.state.get()).recordSuccess();
    }

    public String toString() {
        return this.getState().toString();
    }

    protected void recordResult(R result, Throwable exception) {
        if (this.isFailure((Object)result, exception)) {
            ((CircuitState)this.state.get()).recordFailure(null);
        } else {
            ((CircuitState)this.state.get()).recordSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionTo(CircuitBreaker.State newState, EventListener<CircuitBreakerStateChangedEvent> listener, ExecutionContext<R> context) {
        CircuitBreaker.State currentState;
        boolean transitioned = false;
        CircuitBreakerImpl circuitBreakerImpl = this;
        synchronized (circuitBreakerImpl) {
            currentState = this.getState();
            if (!this.getState().equals((Object)newState)) {
                switch (newState) {
                    case CLOSED: {
                        this.state.set(new ClosedState(this));
                        break;
                    }
                    case OPEN: {
                        Duration computedDelay = this.computeDelay(context);
                        this.state.set(new OpenState(this, (CircuitState)this.state.get(), computedDelay != null ? computedDelay : this.config.getDelay()));
                        break;
                    }
                    case HALF_OPEN: {
                        this.state.set(new HalfOpenState(this));
                    }
                }
                transitioned = true;
            }
        }
        if (transitioned && listener != null) {
            try {
                listener.accept(new CircuitBreakerStateChangedEvent(currentState));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void recordExecutionFailure(ExecutionContext<R> context) {
        ((CircuitState)this.state.get()).recordFailure(context);
    }

    protected void open(ExecutionContext<R> context) {
        this.transitionTo(CircuitBreaker.State.OPEN, this.config.getOpenListener(), context);
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new CircuitBreakerExecutor(this, policyIndex);
    }
}

