/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe.internal;

import org.rascalmpl.dev.failsafe.RateLimitExceededException;
import org.rascalmpl.dev.failsafe.RateLimiterConfig;
import org.rascalmpl.dev.failsafe.internal.RateLimiterImpl;
import org.rascalmpl.dev.failsafe.spi.ExecutionResult;
import org.rascalmpl.dev.failsafe.spi.FailsafeFuture;
import org.rascalmpl.dev.failsafe.spi.PolicyExecutor;
import org.rascalmpl.dev.failsafe.spi.Scheduler;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Exception;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.concurrent.CompletableFuture;
import org.rascalmpl.java.util.concurrent.Future;

public class RateLimiterExecutor<R extends Object>
extends PolicyExecutor<R> {
    private final RateLimiterImpl<R> rateLimiter;
    private final Duration maxWaitTime;

    public RateLimiterExecutor(RateLimiterImpl<R> rateLimiter, int policyIndex) {
        super(rateLimiter, policyIndex);
        this.rateLimiter = rateLimiter;
        this.maxWaitTime = ((RateLimiterConfig)rateLimiter.getConfig()).getMaxWaitTime();
    }

    @Override
    protected ExecutionResult<R> preExecute() {
        try {
            return this.rateLimiter.tryAcquirePermit(this.maxWaitTime) ? null : ExecutionResult.exception((Throwable)((java.lang.Object)new RateLimitExceededException(this.rateLimiter)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ExecutionResult.exception((Throwable)((java.lang.Object)e));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> future) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got ()Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$preExecuteAsync$1(CompletableFuture promise, Future permitWaitFuture, Boolean mayInterrupt, ExecutionResult cancelResult) {
        promise.complete((Object)cancelResult);
        permitWaitFuture.cancel(mayInterrupt.booleanValue());
    }

    private static /* synthetic */ Object lambda$preExecuteAsync$0(CompletableFuture promise) throws Exception {
        promise.complete(ExecutionResult.none());
        return null;
    }
}

