/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe.internal;

import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.time.Duration;

abstract class RateLimiterStats
extends Object {
    final Stopwatch stopwatch;

    RateLimiterStats(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    abstract long acquirePermits(long var1, Duration var3);

    boolean exceedsMaxWaitTime(long waitNanos, Duration maxWaitTime) {
        return maxWaitTime != null && waitNanos > maxWaitTime.toNanos();
    }

    Duration getElapsed() {
        return Duration.ofNanos((long)this.stopwatch.elapsedNanos());
    }

    abstract void reset();

    static class Stopwatch
    extends Object {
        private long startTime = System.nanoTime();

        Stopwatch() {
        }

        long elapsedNanos() {
            return System.nanoTime() - this.startTime;
        }

        void reset() {
            this.startTime = System.nanoTime();
        }
    }
}

