/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe.spi;

import org.rascalmpl.dev.failsafe.DelayablePolicyConfig;
import org.rascalmpl.dev.failsafe.ExecutionContext;
import org.rascalmpl.dev.failsafe.Policy;
import org.rascalmpl.dev.failsafe.PolicyConfig;
import org.rascalmpl.dev.failsafe.internal.util.Durations;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.time.Duration;

public interface DelayablePolicy<R extends Object>
extends Policy<R> {
    @Override
    public DelayablePolicyConfig<R> getConfig();

    default public Duration computeDelay(ExecutionContext<R> context) {
        PolicyConfig config = this.getConfig();
        Duration computed = null;
        if (context != null && ((DelayablePolicyConfig)config).getDelayFn() != null) {
            boolean delayExceptionMatched;
            R result = context.getLastResult();
            java.lang.Object exception = context.getLastException();
            java.lang.Object delayResult = ((DelayablePolicyConfig)config).getDelayResult();
            Class<Throwable> delayFailure = ((DelayablePolicyConfig)config).getDelayException();
            boolean delayResultMatched = delayResult == null || delayResult.equals(result);
            boolean bl = delayExceptionMatched = delayFailure == null || exception != null && delayFailure.isAssignableFrom(exception.getClass());
            if (delayResultMatched && delayExceptionMatched) {
                try {
                    computed = Durations.ofSafeNanos(((DelayablePolicyConfig)config).getDelayFn().get(context));
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        return computed != null && !computed.isNegative() ? computed : null;
    }
}

