/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dev.failsafe.spi;

import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.CompletableFuture;

public final class ExecutionResult<R extends Object>
extends Object {
    private static final CompletableFuture<?> NULL_FUTURE = CompletableFuture.completedFuture(null);
    private static final ExecutionResult<?> NONE = new ExecutionResult<java.lang.Object>(null, null, true, 0L, true, true, Boolean.valueOf((boolean)true));
    private final R result;
    private final Throwable exception;
    private final boolean nonResult;
    private final long delayNanos;
    private final boolean complete;
    private final boolean success;
    private final Boolean successAll;

    public ExecutionResult(R result, Throwable exception) {
        this(result, exception, false, 0L, true, exception == null, Boolean.valueOf((exception == null ? 1 : 0) != 0));
    }

    private ExecutionResult(R result, Throwable exception, boolean nonResult, long delayNanos, boolean complete, boolean success, Boolean successAll) {
        this.nonResult = nonResult;
        this.result = result;
        this.exception = exception;
        this.delayNanos = delayNanos;
        this.complete = complete;
        this.success = success;
        this.successAll = successAll;
    }

    public static <R extends Object> CompletableFuture<ExecutionResult<R>> nullFuture() {
        return NULL_FUTURE;
    }

    public static <R extends Object> ExecutionResult<R> success(R result) {
        return new ExecutionResult<R>(result, null, false, 0L, true, true, Boolean.valueOf((boolean)true));
    }

    public static <R extends Object> ExecutionResult<R> exception(Throwable exception) {
        return new ExecutionResult<java.lang.Object>(null, exception, false, 0L, true, false, Boolean.valueOf((boolean)false));
    }

    public static <R extends Object> ExecutionResult<R> none() {
        return NONE;
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getDelay() {
        return this.delayNanos;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isNonResult() {
        return this.nonResult;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ExecutionResult<R> withNonResult() {
        return this.success && this.result == null && this.nonResult ? this : new ExecutionResult<java.lang.Object>(null, null, true, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withResult(R result) {
        boolean unchangedNull = this.result == null && result == null && this.exception == null;
        boolean unchangedNotNull = this.result != null && this.result.equals(result);
        return this.success && (unchangedNull || unchangedNotNull) ? this : new ExecutionResult<R>(result, null, this.nonResult, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withNotComplete() {
        return !this.complete ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, false, this.success, this.successAll);
    }

    public ExecutionResult<R> withException() {
        return !this.success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, this.complete, false, Boolean.valueOf((boolean)false));
    }

    public ExecutionResult<R> withSuccess() {
        return this.complete && this.success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, this.delayNanos, true, true, this.successAll);
    }

    public ExecutionResult<R> withDelay(long delayNanos) {
        return this.delayNanos == delayNanos ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, delayNanos, this.complete, this.success, this.successAll);
    }

    public ExecutionResult<R> with(long delayNanos, boolean complete, boolean success) {
        return this.delayNanos == delayNanos && this.complete == complete && this.success == success ? this : new ExecutionResult<R>(this.result, this.exception, this.nonResult, delayNanos, complete, success, Boolean.valueOf((boolean)(this.successAll == null ? success : success && this.successAll.booleanValue())));
    }

    public boolean getSuccessAll() {
        return this.successAll != null && this.successAll.booleanValue();
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.[result=").append(this.result).append((String)"org.rascalmpl., exception=").append((Object)this.exception).append((String)"org.rascalmpl., nonResult=").append(this.nonResult).append((String)"org.rascalmpl., delayNanos=").append(this.delayNanos).append((String)"org.rascalmpl., complete=").append(this.complete).append((String)"org.rascalmpl., success=").append(this.success).append((String)"org.rascalmpl., successAll=").append((Object)this.successAll).append(']').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionResult that = (ExecutionResult)o;
        return Objects.equals(this.result, that.result) && Objects.equals((Object)this.exception, (Object)that.exception);
    }

    public int hashCode() {
        return Objects.hash((Object[])new Object[]{this.result, this.exception});
    }
}

