/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api;

import org.rascalmpl.io.opentelemetry.api.DefaultOpenTelemetry;
import org.rascalmpl.io.opentelemetry.api.logs.LoggerProvider;
import org.rascalmpl.io.opentelemetry.api.metrics.Meter;
import org.rascalmpl.io.opentelemetry.api.metrics.MeterBuilder;
import org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.io.opentelemetry.api.trace.Tracer;
import org.rascalmpl.io.opentelemetry.api.trace.TracerBuilder;
import org.rascalmpl.io.opentelemetry.api.trace.TracerProvider;
import org.rascalmpl.io.opentelemetry.context.propagation.ContextPropagators;
import org.rascalmpl.java.lang.String;

public interface OpenTelemetry {
    public static OpenTelemetry noop() {
        return DefaultOpenTelemetry.getNoop();
    }

    public static OpenTelemetry propagating(ContextPropagators propagators) {
        return DefaultOpenTelemetry.getPropagating(propagators);
    }

    public TracerProvider getTracerProvider();

    default public Tracer getTracer(String instrumentationScopeName) {
        return this.getTracerProvider().get(instrumentationScopeName);
    }

    default public Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.getTracerProvider().get(instrumentationScopeName, instrumentationScopeVersion);
    }

    default public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return this.getTracerProvider().tracerBuilder(instrumentationScopeName);
    }

    default public MeterProvider getMeterProvider() {
        return MeterProvider.noop();
    }

    default public Meter getMeter(String instrumentationScopeName) {
        return this.getMeterProvider().get(instrumentationScopeName);
    }

    default public MeterBuilder meterBuilder(String instrumentationScopeName) {
        return this.getMeterProvider().meterBuilder(instrumentationScopeName);
    }

    default public LoggerProvider getLogsBridge() {
        return LoggerProvider.noop();
    }

    public ContextPropagators getPropagators();
}

